
public class QuickSort2  extends SortingAlgorithm {
  
  
  private final int delta;
  
  
  public QuickSort2( int switchSize ) {
    
    if ( switchSize > 0 ) {    // Definizione soglia
      delta = switchSize - 1;
    } else {
      delta = 0;
    }
  }
  
  
  // Schema di ordinamento "Quick Sort"
  
  private void quickSort( int l, int u, int[] seq ) {
    
    while ( l + delta < u ) {
      int m = seq[l];
      int i = l;
      int j = u;
      do {
        while ( seq[i] < m ) {
          i = i + 1;
        }
        while ( seq[j] > m ) {
          j = j - 1;
        }
        if ( i < j ) {
          int x = seq[i];
          seq[i] = seq[j];
          seq[j] = x;
          i = i + 1;
          j = j - 1;
        }
      } while ( i < j );
      
      if ( seq[j] > m ) {
        j = j - 1;
      }
      quickSort( l, j, seq );
      l = j+1;
    }
  }
  
  public void sort( int[] seq ) {
    
    quickSort( 0, seq.length-1, seq );
  }
  
  
}  // class QuickSort2

