
/*
 * Unit Testing (JUnit)
 *
 * Strumenti disponibili:
 *
 *   void assertTrue( String failureMessage, boolean condition )
 *
 *   void assertEquals( String failureMessage, int expectedValue, int actualValue )
 *     ...
 *   void assertEquals( String failureMessage, Object expectedObject, Object actualObject )  // equals(...)
 *
 *   void fail( String failureMessage )
 *
 *   protected void setUp()
 *
 *     ...
 */


import junit.framework.*;


public class UnitTesting  extends TestCase {
  
  
  private int size;
  private int[] seq;
  private int switchSize;
  
  
  protected void setUp() {
  
    size = 1000;
    seq = randomSeq( size );
    
    switchSize = 10;
  }
  
  
  public void testQuickSort() {
    
    SortingAlgorithm qs = new QuickSort1( switchSize );
    
    qs.sort( seq );
    
    for ( int i=0; i+switchSize<size; i=i+1 ) {
      
      assertTrue(
        "testing that seq is partially ordered",
        ( seq[i] <= seq[i+switchSize] )
      );
    }
  }  
  
  
  public void testInsertionSort() {
    
    SortingAlgorithm is = new InsertionSort();
    
    is.sort( seq );
    
    for ( int i=0; i+1<size; i=i+1 ) {
      
      assertTrue(
        "testing that seq is ordered",
        ( seq[i] <= seq[i+1] )
      );
    }
  }
  
  
  public void testFasterSort() {
    
    testQuickSort();
    
    testInsertionSort();
  }  
  
  
  private static int[] randomSeq( int size ) {
    
    int[] seq = new int[ size ];
    
    for ( int i=0; i<size; i++ ) {
      
      seq[i] = (int) ( 10 * size * Math.random() );
    }
    return seq;
  }  
  
}  // testing unit class UnitTesting

