
/*
 * class "SortingTest"
 *
 * Sperimentazione di algoritmi di ordinamento
 */


public class SortingTest {


  // Selezione dell'algoritmo di ordinamento
  
  public static SortingAlgorithm testAlgorithm( String option ) {
  
    SortingAlgorithm algorithm;
    
    if        ( option.equals("IS") ) {
      algorithm = new InsertionSort();
    } else if ( option.equals("QS") ) {
      algorithm = new QuickSort();
    } else if ( option.equals("HS") ) {
      algorithm = new HeapSort();
    } else { // args[0]: "QA" / "QB" / "FS" + n
      int n = Integer.parseInt( option.substring(2) );
      option = option.substring( 0, 2 );
      if        ( option.equals("QA") ) {
        algorithm = new QuickSort1( n );
      } else if ( option.equals("QB") ) {
        algorithm = new QuickSort2( n );
      } else if ( option.equals("FS") ) {
        algorithm = new FasterSort( n );
      } else {
        algorithm = null;
    }}
    return algorithm;
  }
  
  
  // Test di ordinamento
  
  private static String testSorting( SortingAlgorithm algorithm, int[] seq ) {
    
    String in  = "";
    String out = "";
    
    for ( int i=0; i<seq.length; i++ ) {
      in = in + "  " + seq[i];
    }
    in = in + "\n";
    
    algorithm.sort( seq );
    
    for ( int i=0; i<seq.length; i++ ) {
      out = out + "  " + seq[i];
    }
    out = out + "\n";
    
    return ( in + out );
  }
  
  
  // Utilizzo degli strumenti
  
  public static void main( String[] args ) {

    SortingAlgorithm algorithm = testAlgorithm( args[0] );
    
    if ( (args.length > 2) && (algorithm != null) ) {
      
      int[] seq = new int[ args.length - 1 ];
      
      for ( int i=1; i<args.length; i++ ) {
        seq[i-1] = Integer.parseInt( args[i] );
      }
      System.out.println( testSorting(algorithm,seq) );
      
    } else {
      
      int size = Integer.parseInt( args[1] );
      
      System.out.println( "  time cost = " + Measures.timeCost(algorithm,size) + " msec" );
    }
  }

}  // class SortingTest

