
/*
 * class "Measures"
 *
 * Rilevamento sperimentale dei tempi di elaborazione
 * relativi all'ordinamento di un array
 *
 * Modello di riferimento: SortingAlgorithm
 */


import java.util.*;


public class Measures {


  private static final long TMIN = 3000;  // Tempo misurato dell'orine di 3 sec
  
  
  public static double timeCost( SortingAlgorithm algorithm, int size ) {

    int[] seq = new int[ size ];
    int count = 0;
    long t;
    
    // Misura dei tempi di elaborazione su un campione di array generati random
    
    long t0 = ( new Date() ).getTime();   // Avvio cronomentro
    
    do {
      
      count = count + 1;                  // Numero di ordinamenti
      
      for ( int i=0; i<size; i++ ) {      // Array random di dimensione size
        
        seq[i] = (int) ( 10 * size * Math.random() );
      }
      algorithm.sort( seq );              // Ordinamento
      
      t = ( new Date() ).getTime() - t0;
      
    } while ( t < TMIN );                 // Controllo cronometro
    
    // Compensazione di errori sistematici prevedibili
    
    long t1 = ( new Date() ).getTime();
    long u  = 0;
    
    for ( int k=0; k<count; k++ ) {       // Compensazione iterazioni 'do-while'
      
      for ( int i=0; i<size; i++ ) {      // Compensazione generatore random
        
        seq[i] = (int) ( 10 * size * Math.random() );
      }
      u = ( new Date() ).getTime() - t1;  // Compensazione lettura cronometro
    }
    
    // Misura del tempo medio di ordinamento
    
    return ( ((double) t - u) / count );  // Eventuali errori accidentali?
    
    // In particolare: cosa succede se le misure sono rilevate mentre
    // la (le) CPU deve farsi carico di altre elaborazioni importanti?
  }

}  // class Measures

