/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.File;
import java.io.RandomAccessFile;
import smallsql.database.Column;
import smallsql.database.ColumnExpression;
import smallsql.database.Columns;
import smallsql.database.CommandSelect;
import smallsql.database.Database;
import smallsql.database.Expression;
import smallsql.database.ExpressionName;
import smallsql.database.Expressions;
import smallsql.database.SQLParser;
import smallsql.database.SSConnection;
import smallsql.database.StoreImpl;
import smallsql.database.StorePage;
import smallsql.database.TableView;
import smallsql.database.Utils;

class View
extends TableView {
    final String sql;
    final CommandSelect commandSelect;

    View(SSConnection sSConnection, String string, RandomAccessFile randomAccessFile, long l) throws Exception {
        super(string, new Columns());
        int n;
        StorePage storePage = new StorePage(null, -1, randomAccessFile, l);
        StoreImpl storeImpl = StoreImpl.createStore(null, storePage, 200, l);
        this.sql = storeImpl.readString();
        while ((n = storeImpl.readInt()) != 0) {
            int n2 = storeImpl.getCurrentOffsetInPage();
            int n3 = storeImpl.readInt();
            storeImpl.setCurrentOffsetInPage(n2 + n3);
        }
        randomAccessFile.close();
        this.commandSelect = (CommandSelect)new SQLParser().parse(sSConnection, this.sql);
        this.createColumns(sSConnection);
    }

    View(Database database, String string, String string2) throws Exception {
        super(string, new Columns());
        this.sql = string2;
        this.commandSelect = null;
        this.write(database);
    }

    View(SSConnection sSConnection, CommandSelect commandSelect) throws Exception {
        super("UNION", new Columns());
        this.sql = null;
        this.commandSelect = commandSelect;
        this.createColumns(sSConnection);
    }

    private void createColumns(SSConnection sSConnection) throws Exception {
        this.commandSelect.compile(sSConnection);
        Expressions expressions = this.commandSelect.columnExpressions;
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expression = expressions.get(i);
            if (expression instanceof ExpressionName) {
                Column column = ((ExpressionName)expression).getColumn().copy();
                column.setName(expression.getAlias());
                this.columns.add(column);
                continue;
            }
            this.columns.add(new ColumnExpression(expression));
        }
    }

    static void drop(Database database, String string) throws Exception {
        File file = new File(Utils.createTableViewFileName(database, string));
        boolean bl = file.delete();
        if (!bl) {
            throw Utils.createSQLException("View '" + string + "' can't drop.");
        }
    }

    private void write(Database database) throws Exception {
        RandomAccessFile randomAccessFile = this.createFile(database);
        StorePage storePage = new StorePage(null, -1, randomAccessFile, 8L);
        StoreImpl storeImpl = StoreImpl.createStore(null, storePage, 205, 8L);
        storeImpl.writeString(this.sql);
        storeImpl.writeInt(0);
        storeImpl.writeFinsh(null);
        randomAccessFile.close();
    }

    void writeMagic(RandomAccessFile randomAccessFile) throws Exception {
        randomAccessFile.writeInt(1397836886);
        randomAccessFile.writeInt(2);
    }
}

