/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.File;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import smallsql.database.Columns;
import smallsql.database.Database;
import smallsql.database.ForeignKey;
import smallsql.database.ForeignKeys;
import smallsql.database.IndexDescription;
import smallsql.database.IndexDescriptions;
import smallsql.database.Lobs;
import smallsql.database.SSConnection;
import smallsql.database.StoreImpl;
import smallsql.database.StorePage;
import smallsql.database.StorePageLink;
import smallsql.database.TableStorePage;
import smallsql.database.TableStorePageInsert;
import smallsql.database.TableView;
import smallsql.database.Utils;

class Table
extends TableView {
    private static final int INDEX = 1;
    final Database database;
    RandomAccessFile raFile;
    private Lobs lobs;
    long firstPage;
    private final HashMap locks = new HashMap();
    private SSConnection tabLockConnection;
    private int tabLockCount;
    private final ArrayList locksInsert = new ArrayList();
    private final HashMap serializeConnections = new HashMap();
    final IndexDescriptions indexes;
    final ForeignKeys references;
    static final /* synthetic */ boolean $assertionsDisabled;

    Table(Database database, SSConnection sSConnection, String string, RandomAccessFile randomAccessFile, long l, int n) throws Exception {
        super(string, new Columns());
        int n2;
        this.database = database;
        this.raFile = randomAccessFile;
        this.firstPage = l;
        StoreImpl storeImpl = this.getStore(sSConnection, this.firstPage, 200);
        if (storeImpl == null) {
            throw Utils.createSQLException("File '" + this.getFile(database) + "' does not include a valid SmallSQL Table.");
        }
        int n3 = storeImpl.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            this.columns.add(storeImpl.readColumn(this, n));
        }
        this.indexes = new IndexDescriptions();
        this.references = new ForeignKeys();
        while ((n2 = storeImpl.readInt()) != 0) {
            int n4 = storeImpl.getCurrentOffsetInPage();
            int n5 = storeImpl.readInt();
            switch (n2) {
                case 1: {
                    this.indexes.add(IndexDescription.load(database, this, storeImpl));
                }
            }
            storeImpl.setCurrentOffsetInPage(n4 + n5);
        }
        this.firstPage = storeImpl.getNextPagePos();
    }

    Table(Database database, SSConnection sSConnection, String string, Columns columns, IndexDescriptions indexDescriptions, ForeignKeys foreignKeys) throws Exception {
        this(database, sSConnection, string, columns, null, indexDescriptions, foreignKeys);
    }

    Table(Database database, SSConnection sSConnection, String string, Columns columns, IndexDescriptions indexDescriptions, IndexDescriptions indexDescriptions2, ForeignKeys foreignKeys) throws Exception {
        super(string, columns);
        this.database = database;
        this.references = foreignKeys;
        indexDescriptions2.create(database, this);
        if (indexDescriptions == null) {
            this.indexes = indexDescriptions2;
        } else {
            this.indexes = indexDescriptions;
            indexDescriptions.add(indexDescriptions2);
        }
        this.write(sSConnection);
        for (int i = 0; i < foreignKeys.size(); ++i) {
            ForeignKey foreignKey = foreignKeys.get(i);
            Table table = (Table)database.getTableView(sSConnection, foreignKey.pkTable);
            table.references.add(foreignKey);
        }
    }

    Table(Database database, String string) {
        super(string, null);
        this.database = database;
        this.indexes = null;
        this.references = null;
    }

    static void drop(Database database, String string) throws Exception {
        boolean bl = new File(Utils.createTableViewFileName(database, string)).delete();
        if (!bl) {
            throw Utils.createSQLException("Table '" + string + "' can't drop.");
        }
    }

    void drop(SSConnection sSConnection) throws Exception {
        boolean bl;
        TableStorePage tableStorePage = this.requestLock(sSConnection, 205, -1L);
        if (tableStorePage == null) {
            throw Utils.createSQLException("Table '" + this.name + "' can't drop because is locked.");
        }
        sSConnection.rollbackFile(this.raFile);
        this.close();
        if (this.lobs != null) {
            this.lobs.drop(sSConnection);
        }
        if (this.indexes != null) {
            this.indexes.drop(this.database);
        }
        if (!(bl = this.getFile(this.database).delete())) {
            throw Utils.createSQLException("Table '" + this.name + "' can't drop.");
        }
    }

    void close() throws Exception {
        if (this.indexes != null) {
            this.indexes.close();
        }
        this.raFile.close();
        this.raFile = null;
    }

    private void write(SSConnection sSConnection) throws Exception {
        int n;
        this.raFile = this.createFile(this.database);
        this.firstPage = 8L;
        StoreImpl storeImpl = this.getStore(sSConnection, this.firstPage, 205);
        int n2 = this.columns.size();
        storeImpl.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            storeImpl.writeColumn(this, this.columns.get(n));
        }
        for (n = 0; n < this.indexes.size(); ++n) {
            IndexDescription indexDescription = this.indexes.get(n);
            storeImpl.writeInt(1);
            int n3 = storeImpl.getCurrentOffsetInPage();
            storeImpl.setCurrentOffsetInPage(n3 + 4);
            indexDescription.save(storeImpl);
            int n4 = storeImpl.getCurrentOffsetInPage();
            storeImpl.setCurrentOffsetInPage(n3);
            storeImpl.writeInt(n4 - n3);
            storeImpl.setCurrentOffsetInPage(n4);
        }
        storeImpl.writeInt(0);
        storeImpl.writeFinsh(null);
        this.firstPage = storeImpl.getNextPagePos();
    }

    void writeMagic(RandomAccessFile randomAccessFile) throws Exception {
        randomAccessFile.writeInt(1397836884);
        randomAccessFile.writeInt(2);
    }

    StoreImpl getStore(SSConnection sSConnection, long l, int n) throws Exception {
        TableStorePage tableStorePage = this.requestLock(sSConnection, n, l);
        return StoreImpl.createStore(this, tableStorePage, n, l);
    }

    StoreImpl getStore(TableStorePage tableStorePage, int n) throws Exception {
        return StoreImpl.recreateStore(this, tableStorePage, n);
    }

    StoreImpl getStoreInsert(SSConnection sSConnection) throws Exception {
        TableStorePage tableStorePage = this.requestLock(sSConnection, 1104, -1L);
        return StoreImpl.createStore(this, tableStorePage, 1104, -1L);
    }

    StoreImpl getStoreTemp(SSConnection sSConnection) throws Exception {
        TableStorePage tableStorePage = new TableStorePage(sSConnection, this, 0, -2L);
        return StoreImpl.createStore(this, tableStorePage, 1104, -2L);
    }

    StoreImpl getLobStore(SSConnection sSConnection, long l, int n) throws Exception {
        if (this.lobs == null) {
            this.lobs = new Lobs(this);
        }
        return this.lobs.getStore(sSConnection, l, n);
    }

    final long getFirstPage() {
        return this.firstPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getInserts(SSConnection sSConnection) {
        HashMap hashMap = this.locks;
        synchronized (hashMap) {
            ArrayList<StorePageLink> arrayList = new ArrayList<StorePageLink>();
            if (sSConnection.isolationLevel <= 1) {
                for (int i = 0; i < this.locksInsert.size(); ++i) {
                    TableStorePageInsert tableStorePageInsert = (TableStorePageInsert)this.locksInsert.get(i);
                    arrayList.add(tableStorePageInsert.getLink());
                }
            } else {
                for (int i = 0; i < this.locksInsert.size(); ++i) {
                    TableStorePageInsert tableStorePageInsert = (TableStorePageInsert)this.locksInsert.get(i);
                    if (tableStorePageInsert.con != sSConnection) continue;
                    arrayList.add(tableStorePageInsert.getLink());
                }
            }
            return arrayList;
        }
    }

    final TableStorePage requestLock(SSConnection sSConnection, int n, long l) throws Exception {
        HashMap hashMap = this.locks;
        synchronized (hashMap) {
            if (this.raFile == null) {
                throw Utils.createSQLException("Table '" + this.name + "' was modified.");
            }
            long l2 = 0L;
            while (true) {
                long l3;
                TableStorePage tableStorePage;
                if ((tableStorePage = this.requestLockImpl(sSConnection, n, l)) != null) {
                    return tableStorePage;
                }
                if (l2 == 0L) {
                    l2 = System.currentTimeMillis() + 5000L;
                }
                if ((l3 = l2 - System.currentTimeMillis()) <= 0L) {
                    throw Utils.createSQLException("Deadlock, can not create a lock on table '" + this.name + "'");
                }
                this.locks.wait(l3);
            }
        }
    }

    private final TableStorePage requestLockImpl(SSConnection sSConnection, int n, long l) throws SQLException {
        HashMap hashMap = this.locks;
        synchronized (hashMap) {
            if (this.tabLockConnection != null && this.tabLockConnection != sSConnection) {
                return null;
            }
            switch (sSConnection.isolationLevel) {
                case 8: {
                    this.serializeConnections.put(sSConnection, sSConnection);
                }
            }
            switch (n) {
                case 205: {
                    TableStorePage tableStorePage;
                    if (this.locks.size() > 0) {
                        Iterator iterator = this.locks.values().iterator();
                        while (iterator.hasNext()) {
                            tableStorePage = (TableStorePage)iterator.next();
                            if (tableStorePage.con == sSConnection) continue;
                            return null;
                        }
                    }
                    for (int i = 0; i < this.locksInsert.size(); ++i) {
                        tableStorePage = (TableStorePageInsert)this.locksInsert.get(i);
                        if (((TableStorePageInsert)tableStorePage).con == sSConnection) continue;
                        return null;
                    }
                    if (this.serializeConnections.size() > 0) {
                        Iterator iterator = this.serializeConnections.values().iterator();
                        while (iterator.hasNext()) {
                            tableStorePage = (TableStorePage)iterator.next();
                            if (tableStorePage.con == sSConnection) continue;
                            return null;
                        }
                    }
                    this.tabLockConnection = sSConnection;
                    ++this.tabLockCount;
                    TableStorePage tableStorePage2 = new TableStorePage(sSConnection, this, 4, l);
                    sSConnection.add(tableStorePage2);
                    return tableStorePage2;
                }
                case 207: {
                    Object object;
                    if (this.locks.size() > 0 || this.locksInsert.size() > 0) {
                        return null;
                    }
                    if (this.serializeConnections.size() > 0) {
                        object = this.serializeConnections.values().iterator();
                        while (object.hasNext()) {
                            TableStorePage tableStorePage = (TableStorePage)object.next();
                            if (tableStorePage.con == sSConnection) continue;
                            return null;
                        }
                    }
                    this.tabLockConnection = sSConnection;
                    ++this.tabLockCount;
                    object = new TableStorePage(sSConnection, this, 4, l);
                    ((StorePage)object).rollback();
                    return object;
                }
                case 1104: {
                    if (this.serializeConnections.size() > 1) {
                        return null;
                    }
                    if (this.serializeConnections.size() == 1 && this.serializeConnections.get(sSConnection) != null) {
                        return null;
                    }
                    TableStorePageInsert tableStorePageInsert = new TableStorePageInsert(sSConnection, this, 1);
                    this.locksInsert.add(tableStorePageInsert);
                    sSConnection.add(tableStorePageInsert);
                    return tableStorePageInsert;
                }
                case 200: {
                    TableStorePage tableStorePage;
                    Long l2 = new Long(l);
                    TableStorePage tableStorePage3 = tableStorePage = (TableStorePage)this.locks.get(l2);
                    while (tableStorePage3 != null) {
                        if (tableStorePage3.con == sSConnection || sSConnection.isolationLevel <= 1) {
                            return tableStorePage3;
                        }
                        if (tableStorePage3.lockType == 3) {
                            return null;
                        }
                        tableStorePage3 = tableStorePage3.nextLock;
                    }
                    tableStorePage3 = new TableStorePage(sSConnection, this, 0, l);
                    if (sSConnection.isolationLevel >= 4) {
                        tableStorePage3.lockType = 2;
                        tableStorePage3.nextLock = tableStorePage;
                        this.locks.put(l2, tableStorePage3);
                        sSConnection.add(tableStorePage3);
                    }
                    return tableStorePage3;
                }
                case 313: {
                    return new TableStorePage(sSConnection, this, 1, -1L);
                }
            }
            throw new Error("pageOperation:" + n);
        }
    }

    TableStorePage requestWriteLock(SSConnection sSConnection, TableStorePage tableStorePage) throws SQLException {
        TableStorePage tableStorePage2;
        if (tableStorePage.lockType == 1) {
            TableStorePage tableStorePage3;
            tableStorePage.nextLock = tableStorePage3 = new TableStorePage(sSConnection, this, 1, -1L);
            sSConnection.add(tableStorePage3);
            return tableStorePage3;
        }
        Long l = new Long(tableStorePage.fileOffset);
        TableStorePage tableStorePage4 = tableStorePage2 = (TableStorePage)this.locks.get(l);
        while (tableStorePage4 != null) {
            if (tableStorePage4.con != sSConnection) {
                return null;
            }
            if (tableStorePage4.lockType < 3) {
                tableStorePage4.lockType = 3;
                return tableStorePage4;
            }
            tableStorePage4 = tableStorePage4.nextLock;
        }
        tableStorePage4 = new TableStorePage(sSConnection, this, 3, tableStorePage.fileOffset);
        tableStorePage4.nextLock = tableStorePage2;
        this.locks.put(l, tableStorePage4);
        sSConnection.add(tableStorePage4);
        return tableStorePage4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void freeLock(TableStorePage tableStorePage) {
        int n = tableStorePage.lockType;
        long l = tableStorePage.fileOffset;
        HashMap hashMap = this.locks;
        // MONITORENTER : hashMap
        try {
            switch (n) {
                case 1: {
                    for (int i = 0; i < this.locksInsert.size(); ++i) {
                        TableStorePage tableStorePage2;
                        TableStorePage tableStorePage3 = tableStorePage2 = (TableStorePage)this.locksInsert.get(i);
                        while (tableStorePage2 != null) {
                            if (tableStorePage2 == tableStorePage) {
                                if (tableStorePage2 != tableStorePage3) {
                                    tableStorePage3.nextLock = tableStorePage2.nextLock;
                                    return;
                                }
                                if (tableStorePage2.nextLock == null) {
                                    this.locksInsert.remove(i--);
                                    return;
                                }
                                this.locksInsert.set(i, tableStorePage2.nextLock);
                                return;
                            }
                            tableStorePage3 = tableStorePage2;
                            tableStorePage2 = tableStorePage2.nextLock;
                        }
                    }
                    return;
                }
                case 2: 
                case 3: {
                    TableStorePage tableStorePage4;
                    Long l2 = new Long(l);
                    TableStorePage tableStorePage5 = tableStorePage4 = (TableStorePage)this.locks.get(l2);
                    while (tableStorePage4 != null) {
                        if (tableStorePage4 == tableStorePage) {
                            if (tableStorePage4 != tableStorePage5) {
                                tableStorePage5 = tableStorePage4.nextLock;
                                return;
                            }
                            if (tableStorePage4.nextLock == null) {
                                this.locks.remove(l2);
                                return;
                            }
                            this.locks.put(l2, tableStorePage4.nextLock);
                            return;
                        }
                        tableStorePage5 = tableStorePage4;
                        tableStorePage4 = tableStorePage4.nextLock;
                    }
                    return;
                }
                case 4: {
                    if (!$assertionsDisabled && tableStorePage.con != this.tabLockConnection) {
                        throw new AssertionError((Object)"Internal Error with TabLock");
                    }
                    if (--this.tabLockCount != 0) return;
                    this.tabLockConnection = null;
                    return;
                }
                default: {
                    throw new Error();
                }
            }
        }
        finally {
            this.locks.notifyAll();
        }
    }

    static {
        $assertionsDisabled = !Table.class.desiredAssertionStatus();
    }
}

