/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.TableStorePage;

class StorePageMap {
    private Entry[] table = new Entry[17];
    private int size;
    private int threshold = 12;

    StorePageMap() {
    }

    final int size() {
        return this.size;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final TableStorePage get(long l) {
        int n = (int)(l % (long)this.table.length);
        Entry entry = this.table[n];
        while (entry != null) {
            if (entry.key == l) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    final boolean containsKey(long l) {
        return this.get(l) != null;
    }

    final TableStorePage add(long l, TableStorePage tableStorePage) {
        int n = (int)(l % (long)this.table.length);
        this.table[n] = new Entry(l, tableStorePage, this.table[n]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return null;
    }

    private final void resize(int n) {
        Entry[] entryArray = new Entry[n];
        this.transfer(entryArray);
        this.table = entryArray;
        this.threshold = (int)((float)n * 0.75f);
    }

    private final void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                entry2.next = null;
                int n2 = (int)(entry2.key % (long)n);
                if (entryArray[n2] == null) {
                    entryArray[n2] = entry2;
                    continue;
                }
                Entry entry3 = entryArray[n2];
                while (entry3.next != null) {
                    entry3 = entry3.next;
                }
                entry3.next = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    final TableStorePage remove(long l) {
        Entry entry;
        int n = (int)(l % (long)this.table.length);
        Entry entry2 = entry = this.table[n];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == l) {
                --this.size;
                if (entry == entry2) {
                    this.table[n] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    final void clear() {
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    final boolean containsValue(TableStorePage tableStorePage) {
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (tableStorePage.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    static class Entry {
        final long key;
        final TableStorePage value;
        Entry next;

        Entry(long l, TableStorePage tableStorePage, Entry entry) {
            this.value = tableStorePage;
            this.next = entry;
            this.key = l;
        }
    }
}

