/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.RandomAccessFile;
import java.sql.SQLException;
import smallsql.database.Utils;

class StorePage {
    byte[] page;
    int pageSize;
    RandomAccessFile raFile;
    long fileOffset;

    StorePage(byte[] byArray, int n, RandomAccessFile randomAccessFile, long l) {
        this.page = byArray;
        this.pageSize = n;
        this.raFile = randomAccessFile;
        this.fileOffset = l;
    }

    final void setPageData(byte[] byArray, int n) {
        this.page = byArray;
        this.pageSize = n;
    }

    long commit() throws SQLException {
        try {
            if (this.raFile != null) {
                if (this.fileOffset < 0L) {
                    this.fileOffset = this.raFile.length();
                }
                this.raFile.seek(this.fileOffset);
                this.raFile.write(this.page, 0, this.pageSize);
            }
            return this.fileOffset;
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    final void rollback() {
        this.raFile = null;
    }

    void freeLock() {
    }
}

