/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import smallsql.database.Expression;
import smallsql.database.Expressions;
import smallsql.database.SQLTokenizer;
import smallsql.database.Utils;

public class SSResultSetMetaData
implements ResultSetMetaData {
    Expressions columns;

    public int getColumnCount() throws SQLException {
        return this.columns.size();
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return this.getColumnExpression(n).isAutoIncrement();
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return this.getColumnExpression(n).isCaseSensitive();
    }

    public boolean isSearchable(int n) throws SQLException {
        int n2 = this.getColumnExpression(n).getType();
        return n2 == 2 || n2 == 3;
    }

    public boolean isCurrency(int n) throws SQLException {
        switch (this.getColumnExpression(n).getDataType()) {
            case 330: 
            case 331: {
                return true;
            }
        }
        return false;
    }

    public int isNullable(int n) throws SQLException {
        return this.getColumnExpression(n).isNullable() ? 1 : 0;
    }

    public boolean isSigned(int n) throws SQLException {
        return SSResultSetMetaData.isSignedDataType(this.getColumnExpression(n).getDataType());
    }

    static boolean isSignedDataType(int n) {
        switch (n) {
            case 322: 
            case 323: 
            case 325: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 336: 
            case 337: 
            case 338: {
                return true;
            }
        }
        return false;
    }

    static boolean isNumberDataType(int n) {
        return SSResultSetMetaData.isSignedDataType(n) || n == 321;
    }

    static boolean isBinaryDataType(int n) {
        switch (n) {
            case 310: 
            case 311: 
            case 313: 
            case 316: {
                return true;
            }
        }
        return false;
    }

    static int getDisplaySize(int n, int n2, int n3) {
        switch (n) {
            case 300: {
                return 1;
            }
            case 301: {
                return 5;
            }
            case 321: {
                return 3;
            }
            case 322: {
                return 6;
            }
            case 323: {
                return 10;
            }
            case 325: 
            case 331: {
                return 19;
            }
            case 336: {
                return 13;
            }
            case 337: 
            case 338: {
                return 17;
            }
            case 313: 
            case 359: 
            case 360: 
            case 371: {
                return Integer.MAX_VALUE;
            }
            case 333: {
                return n2 + (n3 > 0 ? 2 : 1);
            }
            case 310: 
            case 311: {
                return 2 + n2 * 2;
            }
            case 343: {
                return 21;
            }
        }
        return n2;
    }

    static int getDataTypePrecision(int n, int n2) {
        switch (n) {
            case 504: {
                return 0;
            }
            case 300: 
            case 301: {
                return 1;
            }
            case 321: {
                return 3;
            }
            case 322: {
                return 5;
            }
            case 323: 
            case 330: {
                return 10;
            }
            case 325: 
            case 331: {
                return 19;
            }
            case 336: {
                return 7;
            }
            case 337: 
            case 338: {
                return 15;
            }
            case 310: 
            case 311: 
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                if (n2 == -1) {
                    return 65535;
                }
                return n2;
            }
            case 332: 
            case 333: {
                if (n2 == -1) {
                    return 38;
                }
                return n2;
            }
            case 342: {
                return 23;
            }
            case 341: {
                return 8;
            }
            case 340: {
                return 10;
            }
            case 343: {
                return 16;
            }
            case 370: {
                return 36;
            }
            case 313: 
            case 359: 
            case 360: {
                return Integer.MAX_VALUE;
            }
        }
        if (n2 == -1) {
            throw new Error("Precision:" + SQLTokenizer.getKeyWord(n));
        }
        return n2;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        return this.getColumnExpression(n).getDisplaySize();
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnExpression(n).getAlias();
    }

    public String getColumnName(int n) throws SQLException {
        return this.getColumnExpression(n).getAlias();
    }

    public String getSchemaName(int n) throws SQLException {
        return null;
    }

    public int getPrecision(int n) throws SQLException {
        return this.getColumnExpression(n).getPrecision();
    }

    public int getScale(int n) throws SQLException {
        return this.getColumnExpression(n).getScale();
    }

    public String getTableName(int n) throws SQLException {
        return this.getColumnExpression(n).getTableName();
    }

    public String getCatalogName(int n) throws SQLException {
        return null;
    }

    public int getColumnType(int n) throws SQLException {
        return SQLTokenizer.getSQLDataType(this.getColumnExpression(n).getDataType());
    }

    public String getColumnTypeName(int n) throws SQLException {
        return SQLTokenizer.getKeyWord(this.getColumnExpression(n).getDataType());
    }

    public boolean isReadOnly(int n) throws SQLException {
        return !this.getColumnExpression(n).isDefinitelyWritable();
    }

    public boolean isWritable(int n) throws SQLException {
        return this.getColumnExpression(n).isDefinitelyWritable();
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return this.getColumnExpression(n).isDefinitelyWritable();
    }

    public String getColumnClassName(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -7: 
            case 16: {
                return "java.lang.Boolean";
            }
            case -4: 
            case -3: 
            case -2: {
                return "[B";
            }
            case 2004: {
                return "java.sql.Blob";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case -11: 
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 2005: {
                return "java.sql.Clob";
            }
        }
        return "java.lang.Object";
    }

    final int getColumnIdx(int n) throws SQLException {
        if (n < 1 || n > this.columns.size()) {
            throw Utils.createSQLException("Column index out of range:" + n);
        }
        return n - 1;
    }

    final Expression getColumnExpression(int n) throws SQLException {
        return this.columns.get(this.getColumnIdx(n));
    }
}

