/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import smallsql.database.CommandSelect;
import smallsql.database.Database;
import smallsql.database.ExpressionName;
import smallsql.database.Expressions;
import smallsql.database.SQLTokenizer;
import smallsql.database.SSConnection;
import smallsql.database.SSDriver;
import smallsql.database.SSResultSet;
import smallsql.database.SSStatement;
import smallsql.database.Strings;
import smallsql.database.Utils;
import smallsql.database.View;

final class SSDatabaseMetaData
implements DatabaseMetaData {
    private final SSConnection con;
    private final SSStatement st;

    SSDatabaseMetaData(SSConnection sSConnection) throws SQLException {
        this.con = sSConnection;
        this.st = new SSStatement(sSConnection);
    }

    public boolean allProceduresAreCallable() {
        return true;
    }

    public boolean allTablesAreSelectable() {
        return true;
    }

    public String getURL() throws SQLException {
        Database database = this.con.getDatabase(true);
        if (database == null) {
            return "jdbc:smallsql";
        }
        return "jdbc:smallsql:" + database.getName();
    }

    public String getUserName() {
        return "";
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean nullsAreSortedHigh() {
        return false;
    }

    public boolean nullsAreSortedLow() {
        return true;
    }

    public boolean nullsAreSortedAtStart() {
        return false;
    }

    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    public String getDatabaseProductName() {
        return "SmallSQL Database";
    }

    public String getDatabaseProductVersion() {
        return this.getDriverVersion();
    }

    public String getDriverName() {
        return "SmallSQL Driver";
    }

    public String getDriverVersion() {
        return this.getDriverMajorVersion() + "." + SSDriver.drv.getMinorVersion();
    }

    public int getDriverMajorVersion() {
        return SSDriver.drv.getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return SSDriver.drv.getMinorVersion();
    }

    public boolean usesLocalFiles() {
        return false;
    }

    public boolean usesLocalFilePerTable() {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() {
        return true;
    }

    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public String getSQLKeywords() {
        return "database,use";
    }

    private String getFunctions(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i <= n2; ++i) {
            if (i != n) {
                stringBuffer.append(',');
            }
            stringBuffer.append(SQLTokenizer.getKeyWord(i));
        }
        return stringBuffer.toString();
    }

    public String getNumericFunctions() {
        return this.getFunctions(1000, 1023);
    }

    public String getStringFunctions() {
        return this.getFunctions(1100, 1118);
    }

    public String getSystemFunctions() {
        return this.getFunctions(1301, 1305);
    }

    public String getTimeDateFunctions() {
        return this.getFunctions(1200, 1218);
    }

    public String getSearchStringEscape() {
        return "\\";
    }

    public String getExtraNameCharacters() {
        return "#$\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff";
    }

    public boolean supportsAlterTableWithAddColumn() {
        throw new UnsupportedOperationException("Method supportsAlterTableWithAddColumn() not yet implemented.");
    }

    public boolean supportsAlterTableWithDropColumn() {
        throw new UnsupportedOperationException("Method supportsAlterTableWithDropColumn() not yet implemented.");
    }

    public boolean supportsColumnAliasing() {
        return true;
    }

    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    public boolean supportsConvert() {
        return true;
    }

    public boolean supportsConvert(int n, int n2) {
        return true;
    }

    public boolean supportsTableCorrelationNames() {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsGroupByUnrelated() {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    public boolean supportsLikeEscapeClause() {
        return true;
    }

    public boolean supportsMultipleResultSets() {
        return true;
    }

    public boolean supportsMultipleTransactions() {
        return true;
    }

    public boolean supportsNonNullableColumns() {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() {
        return true;
    }

    public boolean supportsANSI92FullSQL() {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    public boolean supportsOuterJoins() {
        return true;
    }

    public boolean supportsFullOuterJoins() {
        return true;
    }

    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    public String getSchemaTerm() {
        return "owner";
    }

    public String getProcedureTerm() {
        return "procedure";
    }

    public String getCatalogTerm() {
        return "database";
    }

    public boolean isCatalogAtStart() {
        return true;
    }

    public String getCatalogSeparator() {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() {
        return true;
    }

    public boolean supportsCatalogsInProcedureCalls() {
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() {
        return true;
    }

    public boolean supportsCatalogsInIndexDefinitions() {
        return true;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return true;
    }

    public boolean supportsPositionedDelete() {
        return true;
    }

    public boolean supportsPositionedUpdate() {
        return true;
    }

    public boolean supportsSelectForUpdate() {
        return true;
    }

    public boolean supportsStoredProcedures() {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    public boolean supportsSubqueriesInExists() {
        return true;
    }

    public boolean supportsSubqueriesInIns() {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    public boolean supportsUnion() {
        return true;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    public int getMaxCharLiteralLength() {
        return 0;
    }

    public int getMaxColumnNameLength() {
        return 255;
    }

    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    public int getMaxColumnsInIndex() {
        return 0;
    }

    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    public int getMaxColumnsInSelect() {
        return 0;
    }

    public int getMaxColumnsInTable() {
        return 0;
    }

    public int getMaxConnections() {
        return 0;
    }

    public int getMaxCursorNameLength() {
        return 0;
    }

    public int getMaxIndexLength() {
        return 0;
    }

    public int getMaxSchemaNameLength() {
        return 255;
    }

    public int getMaxProcedureNameLength() {
        return 255;
    }

    public int getMaxCatalogNameLength() {
        return 255;
    }

    public int getMaxRowSize() {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    public int getMaxStatementLength() {
        return 0;
    }

    public int getMaxStatements() {
        return 0;
    }

    public int getMaxTableNameLength() {
        return 255;
    }

    public int getMaxTablesInSelect() {
        return 0;
    }

    public int getMaxUserNameLength() {
        return 0;
    }

    public int getDefaultTransactionIsolation() {
        return 2;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "", "", "", "REMARKS", "PROCEDURE_TYPE"};
        Object[][] objectArray = new Object[][]{};
        return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        String[] stringArray = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS"};
        Object[][] objectArray = new Object[][]{};
        return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        Object object;
        Database database;
        String[] stringArray2 = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"};
        if (string == null) {
            database = this.con.getDatabase(true);
            if (database != null) {
                string = database.getName();
            }
        } else {
            database = Database.getDatabase(string, this.con, false);
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        boolean bl = stringArray == null;
        boolean bl2 = stringArray == null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if ("TABLE".equalsIgnoreCase(stringArray[i])) {
                bl = true;
            }
            if (!"VIEW".equalsIgnoreCase(stringArray[i])) continue;
            bl2 = true;
        }
        if (database != null) {
            Strings strings = database.getTables(string3);
            for (int i = 0; i < strings.size(); ++i) {
                object = strings.get(i);
                Object[] objectArray = new Object[10];
                objectArray[0] = string;
                objectArray[2] = object;
                try {
                    if (database.getTableView(this.con, (String)object) instanceof View) {
                        if (!bl2) continue;
                        objectArray[3] = "VIEW";
                        arrayList.add(objectArray);
                        continue;
                    }
                    if (!bl) continue;
                    objectArray[3] = "TABLE";
                    arrayList.add(objectArray);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Object[][] objectArray = new Object[arrayList.size()][];
        arrayList.toArray((T[])objectArray);
        CommandSelect commandSelect = Utils.createMemoryCommandSelect(this.con, stringArray2, objectArray);
        object = new Expressions();
        ((Expressions)object).add(new ExpressionName("TABLE_TYPE"));
        ((Expressions)object).add(new ExpressionName("TABLE_NAME"));
        commandSelect.setOrder((Expressions)object);
        return new SSResultSet(this.st, commandSelect);
    }

    public ResultSet getSchemas() throws SQLException {
        String[] stringArray = new String[]{"TABLE_SCHEM"};
        Object[][] objectArray = new Object[][]{};
        return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
    }

    public ResultSet getCatalogs() throws SQLException {
        String[] stringArray = new String[]{"TABLE_CAT"};
        Object[][] objectArray = Database.getCatalogs(this.con.getDatabase(true));
        return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
    }

    public ResultSet getTableTypes() throws SQLException {
        String[] stringArray = new String[]{"TABLE_TYPE"};
        Object[][] objectArray = new Object[][]{{"SYSTEM TABLE"}, {"TABLE"}, {"VIEW"}};
        return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        try {
            String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
            Object[][] objectArray = this.con.getDatabase(false).getColumns(this.con, string3, string4);
            return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        throw new UnsupportedOperationException("Method getColumnPrivileges() not yet implemented.");
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        throw new UnsupportedOperationException("Method getTablePrivileges() not yet implemented.");
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        try {
            String[] stringArray = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
            Object[][] objectArray = this.con.getDatabase(false).getBestRowIdentifier(this.con, string3);
            return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        try {
            String[] stringArray = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
            Object[][] objectArray = new Object[0][0];
            return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        try {
            String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
            Object[][] objectArray = this.con.getDatabase(false).getPrimaryKeys(this.con, string3);
            return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getCrossReference(null, null, null, null, null, string3);
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getCrossReference(null, null, string3, null, null, null);
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        try {
            String[] stringArray = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
            Object[][] objectArray = this.con.getDatabase(false).getReferenceKeys(this.con, string3, string6);
            return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public ResultSet getTypeInfo() throws SQLException {
        String[] stringArray = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        Object[][] objectArray = new Object[][]{{SQLTokenizer.getKeyWord(370), Utils.getShort(SQLTokenizer.getSQLDataType(370)), Utils.getInteger(36), "'", "'", null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(300), Utils.getShort(SQLTokenizer.getSQLDataType(300)), Utils.getInteger(1), null, null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(0), Utils.getInteger(0), null, null, null}, {SQLTokenizer.getKeyWord(321), Utils.getShort(SQLTokenizer.getSQLDataType(321)), Utils.getInteger(3), null, null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(0), Utils.getInteger(0), null, null, null}, {SQLTokenizer.getKeyWord(325), Utils.getShort(SQLTokenizer.getSQLDataType(325)), Utils.getInteger(19), null, null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(0), Utils.getInteger(0), null, null, null}, {SQLTokenizer.getKeyWord(313), Utils.getShort(SQLTokenizer.getSQLDataType(313)), Utils.getInteger(Integer.MAX_VALUE), "0x", null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(311), Utils.getShort(SQLTokenizer.getSQLDataType(311)), Utils.getInteger(65535), "0x", null, "max length", Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(310), Utils.getShort(SQLTokenizer.getSQLDataType(310)), Utils.getInteger(65535), "0x", null, "length", Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(359), Utils.getShort(SQLTokenizer.getSQLDataType(359)), Utils.getInteger(Integer.MAX_VALUE), "'", "'", null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(360), Utils.getShort(SQLTokenizer.getSQLDataType(360)), Utils.getInteger(Integer.MAX_VALUE), "'", "'", null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(350), Utils.getShort(SQLTokenizer.getSQLDataType(350)), Utils.getInteger(65535), "'", "'", "length", Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(352), Utils.getShort(SQLTokenizer.getSQLDataType(352)), Utils.getInteger(65535), "'", "'", "length", Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(333), Utils.getShort(SQLTokenizer.getSQLDataType(333)), Utils.getInteger(38), null, null, "precision,scale", Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(0), Utils.getInteger(38), null, null, null}, {SQLTokenizer.getKeyWord(332), Utils.getShort(SQLTokenizer.getSQLDataType(332)), Utils.getInteger(38), null, null, "precision,scale", Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(0), Utils.getInteger(38), null, null, null}, {SQLTokenizer.getKeyWord(331), Utils.getShort(SQLTokenizer.getSQLDataType(331)), Utils.getInteger(19), null, null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(4), Utils.getInteger(4), null, null, null}, {SQLTokenizer.getKeyWord(330), Utils.getShort(SQLTokenizer.getSQLDataType(330)), Utils.getInteger(10), null, null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(4), Utils.getInteger(4), null, null, null}, {SQLTokenizer.getKeyWord(323), Utils.getShort(SQLTokenizer.getSQLDataType(323)), Utils.getInteger(10), null, null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(0), Utils.getInteger(0), null, null, null}, {SQLTokenizer.getKeyWord(322), Utils.getShort(SQLTokenizer.getSQLDataType(322)), Utils.getInteger(5), null, null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(0), Utils.getInteger(0), null, null, null}, {SQLTokenizer.getKeyWord(337), Utils.getShort(SQLTokenizer.getSQLDataType(337)), Utils.getInteger(15), null, null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(0), Utils.getInteger(0), null, null, null}, {SQLTokenizer.getKeyWord(336), Utils.getShort(SQLTokenizer.getSQLDataType(336)), Utils.getInteger(7), null, null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(0), Utils.getInteger(0), null, null, null}, {SQLTokenizer.getKeyWord(338), Utils.getShort(SQLTokenizer.getSQLDataType(338)), Utils.getInteger(15), null, null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(0), Utils.getInteger(0), null, null, null}, {SQLTokenizer.getKeyWord(353), Utils.getShort(SQLTokenizer.getSQLDataType(353)), Utils.getInteger(65535), "'", "'", "max length", Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(355), Utils.getShort(SQLTokenizer.getSQLDataType(355)), Utils.getInteger(65535), "'", "'", "max length", Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(301), Utils.getShort(SQLTokenizer.getSQLDataType(301)), Utils.getInteger(1), null, null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(0), Utils.getInteger(0), null, null, null}, {SQLTokenizer.getKeyWord(340), Utils.getShort(SQLTokenizer.getSQLDataType(340)), Utils.getInteger(10), "'", "'", null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(341), Utils.getShort(SQLTokenizer.getSQLDataType(341)), Utils.getInteger(8), "'", "'", null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(342), Utils.getShort(SQLTokenizer.getSQLDataType(342)), Utils.getInteger(23), "'", "'", null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, Utils.getInteger(3), Utils.getInteger(3), null, null, null}, {SQLTokenizer.getKeyWord(343), Utils.getShort(SQLTokenizer.getSQLDataType(343)), Utils.getInteger(16), "'", "'", null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(371), Utils.getShort(SQLTokenizer.getSQLDataType(371)), Utils.getInteger(65535), null, null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(316), Utils.getShort(SQLTokenizer.getSQLDataType(316)), Utils.getInteger(Integer.MAX_VALUE), "0x", null, null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(362), Utils.getShort(SQLTokenizer.getSQLDataType(362)), Utils.getInteger(Integer.MAX_VALUE), "'", "'", null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}, {SQLTokenizer.getKeyWord(363), Utils.getShort(SQLTokenizer.getSQLDataType(363)), Utils.getInteger(Integer.MAX_VALUE), "'", "'", null, Utils.getShort(1), Boolean.FALSE, Utils.getShort(3), null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null}};
        return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        try {
            String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
            Object[][] objectArray = this.con.getDatabase(false).getIndexInfo(this.con, string3, bl);
            return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public boolean supportsResultSetType(int n) {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) {
        return n >= 1003 && n <= 1005 && n2 >= 1007 && n2 <= 1008;
    }

    public boolean ownUpdatesAreVisible(int n) {
        return this.supportsResultSetType(n);
    }

    public boolean ownDeletesAreVisible(int n) {
        return this.supportsResultSetType(n);
    }

    public boolean ownInsertsAreVisible(int n) {
        return this.supportsResultSetType(n);
    }

    public boolean othersUpdatesAreVisible(int n) {
        return this.supportsResultSetType(n);
    }

    public boolean othersDeletesAreVisible(int n) {
        return this.supportsResultSetType(n);
    }

    public boolean othersInsertsAreVisible(int n) {
        return this.supportsResultSetType(n);
    }

    public boolean updatesAreDetected(int n) {
        return false;
    }

    public boolean deletesAreDetected(int n) {
        return this.supportsResultSetType(n);
    }

    public boolean insertsAreDetected(int n) {
        return this.supportsResultSetType(n);
    }

    public boolean supportsBatchUpdates() {
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        String[] stringArray = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS"};
        Object[][] objectArray = new Object[][]{};
        return new SSResultSet(this.st, Utils.createMemoryCommandSelect(this.con, stringArray, objectArray));
    }

    public Connection getConnection() {
        return this.con;
    }

    public boolean supportsSavepoints() {
        return false;
    }

    public boolean supportsNamedParameters() {
        return true;
    }

    public boolean supportsMultipleOpenResults() {
        return true;
    }

    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException("Method getSuperTypes() not yet implemented.");
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException("Method getSuperTables() not yet implemented.");
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw new UnsupportedOperationException("Method getAttributes() not yet implemented.");
    }

    public boolean supportsResultSetHoldability(int n) {
        return true;
    }

    public int getResultSetHoldability() {
        return 1;
    }

    public int getDatabaseMajorVersion() {
        return this.getDriverMajorVersion();
    }

    public int getDatabaseMinorVersion() {
        return this.getDriverMinorVersion();
    }

    public int getJDBCMajorVersion() {
        return 3;
    }

    public int getJDBCMinorVersion() {
        return 0;
    }

    public int getSQLStateType() {
        return 2;
    }

    public boolean locatorsUpdateCopy() {
        return false;
    }

    public boolean supportsStatementPooling() {
        return false;
    }
}

