/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.Expression;
import smallsql.database.LongLongList;
import smallsql.database.RowSource;

final class Join
extends RowSource {
    Expression condition;
    private int type;
    RowSource left;
    RowSource right;
    private boolean isBeforeFirst = true;
    private boolean isAfterLast;
    private boolean isOuterValid = true;
    private boolean[] isFullNotValid;
    private int fullRightRowCounter;
    private int fullRowCount;
    private int fullReturnCounter = -1;
    private LongLongList rowPositions;
    private int row;
    static final int CROSS_JOIN = 1;
    static final int INNER_JOIN = 2;
    static final int LEFT_JOIN = 3;
    static final int FULL_JOIN = 4;
    static final int RIGHT_JOIN = 5;

    Join(int n, RowSource rowSource, RowSource rowSource2, Expression expression) {
        this.type = n;
        this.condition = expression;
        this.left = rowSource;
        this.right = rowSource2;
        if (n == 4) {
            this.isFullNotValid = new boolean[10];
        }
    }

    final boolean isScrollable() {
        return false;
    }

    void beforeFirst() throws Exception {
        this.left.beforeFirst();
        this.right.beforeFirst();
        this.isBeforeFirst = true;
        this.isAfterLast = false;
        this.fullRightRowCounter = 0;
        this.fullRowCount = 0;
        this.fullReturnCounter = -1;
        this.row = 0;
    }

    boolean first() throws Exception {
        boolean bl = this.left.first() && this.right.first();
        this.row = 1;
        this.isBeforeFirst = false;
        this.isAfterLast = false;
        if (!bl) {
            this.noRow();
        }
        return bl;
    }

    boolean next() throws Exception {
        boolean bl;
        if (this.isAfterLast) {
            return false;
        }
        ++this.row;
        if (this.fullReturnCounter >= 0) {
            do {
                if (this.fullReturnCounter >= this.fullRowCount) {
                    this.noRow();
                    return false;
                }
                this.right.next();
            } while (this.isFullNotValid[this.fullReturnCounter++]);
            return true;
        }
        do {
            if (this.isBeforeFirst) {
                bl = this.left.next();
                if (bl) {
                    bl = this.right.first();
                    if (!bl) {
                        switch (this.type) {
                            case 3: 
                            case 4: {
                                this.isOuterValid = false;
                                this.isBeforeFirst = false;
                                this.right.nullRow();
                                return true;
                            }
                        }
                    } else {
                        ++this.fullRightRowCounter;
                    }
                } else if (this.type == 4) {
                    while (this.right.next()) {
                        ++this.fullRightRowCounter;
                    }
                    this.fullRowCount = this.fullRightRowCounter;
                }
            } else {
                bl = this.right.next();
                if (!bl) {
                    switch (this.type) {
                        case 3: 
                        case 4: {
                            if (this.isOuterValid) {
                                this.isOuterValid = false;
                                this.right.nullRow();
                                return true;
                            }
                            this.fullRowCount = Math.max(this.fullRowCount, this.fullRightRowCounter);
                            this.fullRightRowCounter = 0;
                        }
                    }
                    this.isOuterValid = true;
                    bl = this.left.next();
                    if (bl) {
                        bl = this.right.first();
                        if (!bl) {
                            switch (this.type) {
                                case 3: 
                                case 4: {
                                    this.isOuterValid = false;
                                    this.right.nullRow();
                                    return true;
                                }
                            }
                        } else {
                            ++this.fullRightRowCounter;
                        }
                    }
                } else {
                    ++this.fullRightRowCounter;
                }
            }
            this.isBeforeFirst = false;
        } while (bl && !this.getBoolean());
        this.isOuterValid = false;
        if (this.type == 4) {
            if (this.fullRightRowCounter >= this.isFullNotValid.length) {
                boolean[] blArray = new boolean[this.fullRightRowCounter << 1];
                System.arraycopy(this.isFullNotValid, 0, blArray, 0, this.fullRightRowCounter);
                this.isFullNotValid = blArray;
            }
            if (!bl) {
                if (this.fullRowCount == 0) {
                    this.noRow();
                    return false;
                }
                if (this.fullReturnCounter < 0) {
                    this.fullReturnCounter = 0;
                    this.right.first();
                    this.left.nullRow();
                }
                while (this.isFullNotValid[this.fullReturnCounter++]) {
                    if (this.fullReturnCounter >= this.fullRowCount) {
                        this.noRow();
                        return false;
                    }
                    this.right.next();
                }
                return true;
            }
            this.isFullNotValid[this.fullRightRowCounter - 1] = bl;
        }
        if (!bl) {
            this.noRow();
        }
        return bl;
    }

    void afterLast() {
        this.isAfterLast = true;
        this.noRow();
    }

    int getRow() {
        return this.row;
    }

    final long getRowPosition() {
        if (this.rowPositions == null) {
            this.rowPositions = new LongLongList();
        }
        this.rowPositions.add(this.left.getRowPosition(), this.right.getRowPosition());
        return this.rowPositions.size() - 1;
    }

    final void setRowPosition(long l) throws Exception {
        this.left.setRowPosition(this.rowPositions.get1((int)l));
        this.right.setRowPosition(this.rowPositions.get2((int)l));
    }

    final boolean rowInserted() {
        return this.left.rowInserted() || this.right.rowInserted();
    }

    final boolean rowDeleted() {
        return this.left.rowDeleted() || this.right.rowDeleted();
    }

    void nullRow() {
        this.left.nullRow();
        this.right.nullRow();
        this.row = 0;
    }

    void noRow() {
        this.isAfterLast = true;
        this.left.noRow();
        this.right.noRow();
        this.row = 0;
    }

    void execute() throws Exception {
        this.left.execute();
        this.right.execute();
    }

    private boolean getBoolean() throws Exception {
        return this.type == 1 || this.condition.getBoolean();
    }
}

