/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import smallsql.database.Expression;
import smallsql.database.SSConnection;
import smallsql.database.StorePage;
import smallsql.database.Table;

public class Identity
extends Number {
    private final long filePos;
    private final RandomAccessFile raFile;
    private final byte[] page = new byte[8];
    private final Table table;
    private long value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity(Table table, RandomAccessFile randomAccessFile, long l) throws IOException {
        RandomAccessFile randomAccessFile2 = randomAccessFile;
        synchronized (randomAccessFile2) {
            randomAccessFile.seek(l);
            randomAccessFile.read(this.page);
        }
        this.value = (long)this.page[0] << 56 | (long)(this.page[1] & 0xFF) << 48 | (long)(this.page[2] & 0xFF) << 40 | (long)(this.page[3] & 0xFF) << 32 | (long)(this.page[4] & 0xFF) << 24 | (long)((this.page[5] & 0xFF) << 16) | (long)((this.page[6] & 0xFF) << 8) | (long)(this.page[7] & 0xFF);
        this.table = table;
        this.raFile = randomAccessFile;
        this.filePos = l;
    }

    private StorePage createStorePage() {
        this.page[0] = (byte)(this.value >> 56);
        this.page[1] = (byte)(this.value >> 48);
        this.page[2] = (byte)(this.value >> 40);
        this.page[3] = (byte)(this.value >> 32);
        this.page[4] = (byte)(this.value >> 24);
        this.page[5] = (byte)(this.value >> 16);
        this.page[6] = (byte)(this.value >> 8);
        this.page[7] = (byte)this.value;
        return new StorePage(this.page, 8, this.raFile, this.filePos);
    }

    void createNextValue(SSConnection sSConnection) throws SQLException {
        ++this.value;
        sSConnection.add(this.createStorePage());
    }

    void setNextValue(Expression expression) throws Exception {
        if (expression.isNull()) {
            return;
        }
        long l = expression.getLong();
        if (l > this.value) {
            this.value = l;
            this.createStorePage().commit();
        }
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }
}

