/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import smallsql.database.ExpressionValue;
import smallsql.database.Expressions;
import smallsql.database.FileIndexNode;
import smallsql.database.Index;
import smallsql.database.IndexScrollStatus;

class FileIndex
extends Index {
    private final RandomAccessFile raFile;

    public static void main(String[] stringArray) throws Exception {
        File file = File.createTempFile("test", "idx");
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        FileIndex fileIndex = new FileIndex(false, randomAccessFile);
        Expressions expressions = new Expressions();
        ExpressionValue expressionValue = new ExpressionValue();
        expressions.add(expressionValue);
        expressionValue.set("150", 353);
        fileIndex.addValues(1L, expressions);
        expressionValue.set("15", 353);
        fileIndex.addValues(2L, expressions);
        FileIndex.print(fileIndex, expressions);
        fileIndex.save();
        fileIndex.close();
        System.out.println("Idx size:" + file.length());
        randomAccessFile = new RandomAccessFile(file, "rw");
        fileIndex = FileIndex.load(randomAccessFile);
        FileIndex.print(fileIndex, expressions);
    }

    static void print(Index index, Expressions expressions) {
        long l;
        IndexScrollStatus indexScrollStatus = index.createScrollStatus(expressions);
        while ((l = indexScrollStatus.getRowOffset(true)) >= 0L) {
            System.out.println(l);
        }
        System.out.println("============================");
    }

    FileIndex(boolean bl, RandomAccessFile randomAccessFile) {
        this(new FileIndexNode(bl, '\uffff', randomAccessFile), randomAccessFile);
    }

    FileIndex(FileIndexNode fileIndexNode, RandomAccessFile randomAccessFile) {
        super(fileIndexNode);
        this.raFile = randomAccessFile;
    }

    static FileIndex load(RandomAccessFile randomAccessFile) throws Exception {
        boolean bl = randomAccessFile.readBoolean();
        FileIndexNode fileIndexNode = FileIndexNode.loadRootNode(bl, randomAccessFile, randomAccessFile.getFilePointer());
        return new FileIndex(fileIndexNode, randomAccessFile);
    }

    void save() throws Exception {
        this.raFile.writeBoolean(this.rootPage.getUnique());
        ((FileIndexNode)this.rootPage).save();
    }

    void close() throws IOException {
        this.raFile.close();
    }
}

