/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.util.Arrays;
import smallsql.database.Column;
import smallsql.database.DateTime;
import smallsql.database.Expression;
import smallsql.database.ExpressionFunction;
import smallsql.database.ExpressionValue;
import smallsql.database.Money;
import smallsql.database.MutableNumeric;
import smallsql.database.SQLTokenizer;
import smallsql.database.Utils;

public class ExpressionFunctionConvert
extends ExpressionFunction {
    private final Column datatype;

    public ExpressionFunctionConvert(Column column, Expression expression, Expression expression2) {
        Expression[] expressionArray;
        this.datatype = column;
        if (expression2 == null) {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = expression;
        } else {
            Expression[] expressionArray3 = new Expression[2];
            expressionArray3[0] = expression;
            expressionArray = expressionArray3;
            expressionArray3[1] = expression2;
        }
        Expression[] expressionArray4 = expressionArray;
        this.setParams(expressionArray4);
    }

    int getFunction() {
        return 1303;
    }

    boolean isNull() throws Exception {
        return this.param1.isNull();
    }

    boolean getBoolean() throws Exception {
        return ExpressionValue.getBoolean(this.getObject(), this.getDataType());
    }

    int getInt() throws Exception {
        return ExpressionValue.getInt(this.getObject(), this.getDataType());
    }

    long getLong() throws Exception {
        return ExpressionValue.getLong(this.getObject(), this.getDataType());
    }

    float getFloat() throws Exception {
        return ExpressionValue.getFloat(this.getObject(), this.getDataType());
    }

    double getDouble() throws Exception {
        return ExpressionValue.getDouble(this.getObject(), this.getDataType());
    }

    long getMoney() throws Exception {
        return ExpressionValue.getMoney(this.getObject(), this.getDataType());
    }

    MutableNumeric getNumeric() throws Exception {
        return ExpressionValue.getNumeric(this.getObject(), this.getDataType());
    }

    String getString() throws Exception {
        Object object = this.getObject();
        if (object == null) {
            return null;
        }
        switch (this.datatype.getDataType()) {
            case 300: {
                return (Boolean)object != false ? "1" : "0";
            }
        }
        return object.toString();
    }

    Object getObject() throws Exception {
        if (this.param1.isNull()) {
            return null;
        }
        int n = this.getDataType();
        switch (n) {
            case 359: {
                return this.convertToString();
            }
            case 353: {
                String string = this.convertToString();
                int n2 = this.datatype.getDisplaySize();
                if (n2 > string.length()) {
                    return string;
                }
                return string.substring(0, n2);
            }
            case 350: {
                String string = this.convertToString();
                int n3 = this.datatype.getDisplaySize();
                if (n3 > string.length()) {
                    char[] cArray = new char[n3 - string.length()];
                    Arrays.fill(cArray, ' ');
                    return string + new String(cArray);
                }
                return string.substring(0, n3);
            }
            case 313: {
                return this.param1.getBytes();
            }
            case 311: {
                byte[] byArray = this.param1.getBytes();
                int n4 = this.datatype.getPrecision();
                if (n4 < byArray.length) {
                    byte[] byArray2 = new byte[n4];
                    System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n4));
                    return byArray2;
                }
                return byArray;
            }
            case 310: {
                byte[] byArray = this.param1.getBytes();
                int n5 = this.datatype.getPrecision();
                if (n5 != byArray.length) {
                    byte[] byArray3 = new byte[n5];
                    System.arraycopy(byArray, 0, byArray3, 0, Math.min(byArray.length, n5));
                    return byArray3;
                }
                return byArray;
            }
            case 300: 
            case 301: {
                return this.param1.getBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 321: {
                return Utils.getInteger(this.param1.getInt() & 0xFF);
            }
            case 322: {
                return Utils.getInteger((short)this.param1.getInt());
            }
            case 323: {
                return Utils.getInteger(this.param1.getInt());
            }
            case 325: {
                return new Long(this.param1.getLong());
            }
            case 336: {
                return new Float(this.param1.getFloat());
            }
            case 337: 
            case 338: {
                return new Double(this.param1.getDouble());
            }
            case 340: 
            case 341: 
            case 342: 
            case 343: {
                return new DateTime(this.getDateTimeLong(), n);
            }
            case 332: 
            case 333: {
                MutableNumeric mutableNumeric = this.param1.getNumeric();
                if (mutableNumeric != null && (n == 333 || n == 332)) {
                    mutableNumeric.setScale(this.getScale());
                }
                return mutableNumeric;
            }
            case 330: 
            case 331: {
                return Money.createFromUnscaledValue(this.param1.getMoney());
            }
            case 370: {
                switch (this.param1.getDataType()) {
                    case 350: 
                    case 353: 
                    case 359: 
                    case 362: {
                        return Utils.bytes2unique(Utils.unique2bytes(this.param1.getString()), 0);
                    }
                }
                return Utils.bytes2unique(this.param1.getBytes(), 0);
            }
        }
        throw Utils.createSQLException("Unsupported type for CONVERT function:" + SQLTokenizer.getKeyWord(n));
    }

    private final String convertToString() throws Exception {
        if (this.param2 != null) {
            int n = this.param1.getDataType();
            switch (n) {
                case 343: {
                    n = 342;
                }
                case 340: 
                case 341: 
                case 342: {
                    return new DateTime(this.param1.getLong(), n).toString(this.param2.getInt());
                }
            }
            return this.param1.getString();
        }
        return this.param1.getString();
    }

    private final long getDateTimeLong() throws Exception {
        switch (this.param1.getDataType()) {
            case 350: 
            case 353: 
            case 359: {
                return DateTime.parse(this.param1.getString());
            }
        }
        return this.param1.getLong();
    }

    final int getDataType() {
        return this.datatype.getDataType();
    }

    final int getPrecision() {
        int n = this.getDataType();
        switch (n) {
            case 310: 
            case 311: 
            case 332: 
            case 333: 
            case 350: 
            case 353: {
                return this.datatype.getPrecision();
            }
        }
        return super.getPrecision();
    }

    final int getScale() {
        return this.datatype.getScale();
    }
}

