/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.Expression;
import smallsql.database.ExpressionArithmetic;
import smallsql.database.Expressions;
import smallsql.database.MutableNumeric;

final class ExpressionFunctionCase
extends Expression {
    private final Expressions cases = new Expressions();
    private final Expressions results = new Expressions();
    private Expression elseResult = Expression.NULL;
    private int dataType = -1;

    ExpressionFunctionCase() {
        super(3);
    }

    final void addCase(Expression expression, Expression expression2) {
        this.cases.add(expression);
        this.results.add(expression2);
    }

    final void setElseResult(Expression expression) {
        this.elseResult = expression;
    }

    final void setEnd() {
        Expression[] expressionArray = new Expression[this.cases.size() * 2 + (this.elseResult != null ? 1 : 0)];
        int n = 0;
        for (int i = 0; i < this.cases.size(); ++i) {
            expressionArray[n++] = this.cases.get(i);
            expressionArray[n++] = this.results.get(i);
        }
        if (n < expressionArray.length) {
            expressionArray[n] = this.elseResult;
        }
        super.setParams(expressionArray);
    }

    final void setParams(Expression[] expressionArray) {
        super.setParams(expressionArray);
        int n = 0;
        for (int i = 0; i < this.cases.size(); ++i) {
            this.cases.set(i, expressionArray[n++]);
            this.results.set(i, expressionArray[n++]);
        }
        if (n < expressionArray.length) {
            this.elseResult = expressionArray[n];
        }
    }

    void setParamAt(Expression expression, int n) {
        super.setParamAt(expression, n);
        int n2 = n / 2;
        if (n2 >= this.cases.size()) {
            this.elseResult = expression;
            return;
        }
        if (n % 2 > 0) {
            this.results.set(n2, expression);
        } else {
            this.cases.set(n2, expression);
        }
    }

    final int getFunction() {
        return 263;
    }

    final boolean isNull() throws Exception {
        return this.getResult().isNull();
    }

    final boolean getBoolean() throws Exception {
        return this.getResult().getBoolean();
    }

    final int getInt() throws Exception {
        return this.getResult().getInt();
    }

    final long getLong() throws Exception {
        return this.getResult().getLong();
    }

    final float getFloat() throws Exception {
        return this.getResult().getFloat();
    }

    final double getDouble() throws Exception {
        return this.getResult().getDouble();
    }

    final long getMoney() throws Exception {
        return this.getResult().getMoney();
    }

    final MutableNumeric getNumeric() throws Exception {
        return this.getResult().getNumeric();
    }

    final Object getObject() throws Exception {
        return this.getResult().getObject();
    }

    final String getString() throws Exception {
        return this.getResult().getString();
    }

    final byte[] getBytes() throws Exception {
        return this.getResult().getBytes();
    }

    final int getDataType() {
        if (this.dataType < 0) {
            this.dataType = this.elseResult.getDataType();
            for (int i = 0; i < this.results.size(); ++i) {
                this.dataType = ExpressionArithmetic.getDataType(this.dataType, this.results.get(i).getDataType());
            }
        }
        return this.dataType;
    }

    final int getPrecision() {
        int n = 0;
        for (int i = this.results.size() - 1; i >= 0; --i) {
            n = Math.max(n, this.results.get(i).getPrecision());
        }
        return n;
    }

    final int getScale() {
        int n = 0;
        for (int i = this.results.size() - 1; i >= 0; --i) {
            n = Math.max(n, this.results.get(i).getScale());
        }
        return n;
    }

    private final Expression getResult() throws Exception {
        for (int i = 0; i < this.cases.size(); ++i) {
            if (!this.cases.get(i).getBoolean()) continue;
            return this.results.get(i);
        }
        return this.elseResult;
    }
}

