/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import smallsql.database.Column;
import smallsql.database.Columns;
import smallsql.database.Command;
import smallsql.database.Database;
import smallsql.database.ForeignKey;
import smallsql.database.ForeignKeys;
import smallsql.database.IndexDescription;
import smallsql.database.IndexDescriptions;
import smallsql.database.Logger;
import smallsql.database.SSConnection;
import smallsql.database.SSStatement;
import smallsql.database.Table;
import smallsql.database.TableStorePage;
import smallsql.database.Utils;

final class CommandTable
extends Command {
    private final Columns columns = new Columns();
    private final IndexDescriptions indexes = new IndexDescriptions();
    private final ForeignKeys foreignKeys = new ForeignKeys();
    private final int tableCommandType;

    CommandTable(Logger logger, String string, String string2, int n) {
        super(logger);
        this.type = 236;
        this.catalog = string;
        this.name = string2;
        this.tableCommandType = n;
    }

    void addColumn(Column column) throws SQLException {
        this.addColumn(this.columns, column);
    }

    void addIndex(IndexDescription indexDescription) throws SQLException {
        this.indexes.add(indexDescription);
    }

    void addForeingnKey(ForeignKey foreignKey) {
        this.foreignKeys.add(foreignKey);
    }

    void executeImpl(SSConnection sSConnection, SSStatement sSStatement) throws Exception {
        Database database = this.catalog == null ? sSConnection.getDatabase(false) : Database.getDatabase(this.catalog, sSConnection, false);
        switch (this.tableCommandType) {
            case 205: {
                database.createTable(sSConnection, this.name, this.columns, this.indexes, this.foreignKeys);
                break;
            }
            case 230: {
                sSConnection = new SSConnection(sSConnection);
                Table table = (Table)database.getTableView(sSConnection, this.name);
                TableStorePage tableStorePage = table.requestLock(sSConnection, 207, -1L);
                String string = "#" + System.currentTimeMillis() + this.hashCode();
                try {
                    Columns columns = table.columns;
                    Columns columns2 = columns.copy();
                    for (int i = 0; i < this.columns.size(); ++i) {
                        this.addColumn(columns2, this.columns.get(i));
                    }
                    Table table2 = database.createTable(sSConnection, string, columns2, table.indexes, this.indexes, this.foreignKeys);
                    StringBuffer stringBuffer = new StringBuffer(256);
                    stringBuffer.append("INSERT INTO ").append(string).append('(');
                    for (int i = 0; i < columns.size(); ++i) {
                        if (i != 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(columns.get(i).getName());
                    }
                    stringBuffer.append(")  SELECT * FROM ").append(this.name);
                    sSConnection.createStatement().execute(stringBuffer.toString());
                    database.replaceTable(table, table2);
                    break;
                }
                catch (Exception exception) {
                    try {
                        database.dropTable(sSConnection, string);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        this.indexes.drop(database);
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    throw exception;
                }
                finally {
                    tableStorePage.freeLock();
                }
            }
            default: {
                throw new Error();
            }
        }
    }

    private void addColumn(Columns columns, Column column) throws SQLException {
        if (columns.get(column.getName()) != null) {
            throw Utils.createSQLException("There are a duplicated column name \"{0}\".", column.getName());
        }
        columns.add(column);
    }
}

