/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.File;
import smallsql.database.Command;
import smallsql.database.Database;
import smallsql.database.Logger;
import smallsql.database.SSConnection;
import smallsql.database.SSStatement;
import smallsql.database.Utils;

public class CommandDrop
extends Command {
    CommandDrop(Logger logger, String string, String string2, int n) {
        super(logger);
        this.type = n;
        this.catalog = string;
        this.name = string2;
    }

    void executeImpl(SSConnection sSConnection, SSStatement sSStatement) throws Exception {
        switch (this.type) {
            case 235: {
                File file;
                if (this.name.startsWith("file:")) {
                    this.name = this.name.substring(5);
                }
                if (!(file = new File(this.name)).isDirectory() || !new File(file, "smallsql.master").exists()) {
                    throw Utils.createSQLException("Database '" + this.name + "' does not exists.");
                }
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        fileArray[i].delete();
                    }
                }
                file.delete();
                break;
            }
            case 236: {
                Database.dropTable(sSConnection, this.catalog, this.name);
                break;
            }
            case 237: {
                Database.dropView(sSConnection, this.catalog, this.name);
                break;
            }
            case 238: 
            case 239: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new Error();
            }
        }
    }
}

