/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import smallsql.database.Expression;
import smallsql.database.ExpressionValue;
import smallsql.database.Expressions;
import smallsql.database.Logger;
import smallsql.database.SSConnection;
import smallsql.database.SSResultSet;
import smallsql.database.SSStatement;
import smallsql.database.Utils;

abstract class Command {
    int type;
    String catalog;
    String name;
    SSResultSet rs;
    int updateCount = -1;
    final Expressions columnExpressions;
    Expressions params = new Expressions();
    final Logger log;

    Command(Logger logger) {
        this.log = logger;
        this.columnExpressions = new Expressions();
    }

    Command(Logger logger, Expressions expressions) {
        this.log = logger;
        this.columnExpressions = expressions;
    }

    void addColumnExpression(Expression expression) {
        this.columnExpressions.add(expression);
    }

    void addParameter(ExpressionValue expressionValue) {
        this.params.add(expressionValue);
    }

    void verifyParams() throws SQLException {
        for (int i = 0; i < this.params.size(); ++i) {
            if (!((ExpressionValue)this.params.get(i)).isEmpty()) continue;
            throw Utils.createSQLException("Parameter " + (i + 1) + " is empty.");
        }
    }

    void clearParams() {
        for (int i = 0; i < this.params.size(); ++i) {
            ((ExpressionValue)this.params.get(i)).clear();
        }
    }

    private ExpressionValue getParam(int n) throws SQLException {
        if (n < 1 || n > this.params.size()) {
            throw Utils.createSQLException("Parameter index " + n + " out of range. The value must be between 1 and " + this.params.size());
        }
        return (ExpressionValue)this.params.get(n - 1);
    }

    void setParamValue(int n, Object object, int n2) throws SQLException {
        this.getParam(n).set(object, n2);
        if (this.log.isLogging()) {
            this.log.println("param" + n + '=' + object + "; type=" + n2);
        }
    }

    void setParamValue(int n, Object object, int n2, int n3) throws SQLException {
        this.getParam(n).set(object, n2, n3);
        if (this.log.isLogging()) {
            this.log.println("param" + n + '=' + object + "; type=" + n2 + "; length=" + n3);
        }
    }

    final void execute(SSConnection sSConnection, SSStatement sSStatement) throws SQLException {
        int n = sSConnection.getSavepoint();
        try {
            this.executeImpl(sSConnection, sSStatement);
        }
        catch (Throwable throwable) {
            sSConnection.rollback(n);
            throw Utils.createSQLException(throwable);
        }
        finally {
            if (sSConnection.getAutoCommit()) {
                sSConnection.commit();
            }
        }
    }

    abstract void executeImpl(SSConnection var1, SSStatement var2) throws Exception;

    SSResultSet getQueryResult() throws SQLException {
        if (this.rs == null) {
            throw Utils.createSQLException("No ResultSet was produce.");
        }
        return this.rs;
    }

    SSResultSet getResultSet() {
        return this.rs;
    }

    int getUpdateCount() {
        return this.updateCount;
    }

    boolean getMoreResults() {
        this.rs = null;
        this.updateCount = -1;
        return false;
    }

    void setMaxRows(int n) {
    }

    int getMaxRows() {
        return -1;
    }
}

