/*
 * Decompiled with CFR 0.152.
 */
package nim;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nim.DelayManager;
import nim.KnowledgeBase;
import nim.LearningStrategy;
import nim.Nim;
import nim.NimGame;
import nim.NimInterface;
import nim.NimPlayer;
import nim.NimServer;
import nim.NimStrategy;
import nim.NimView;
import nim.RemoteNimUser;
import nim.ScalableStrategy;

public class SettingsPanel
extends JPanel {
    private static final String SCHEDULE = "schedule.txt";
    private static final String[] PLAYER = new String[]{"Human", "Algorithmic", "M-Learning"};
    private static final int HU = 0;
    private static final int AL = 1;
    private static final int ML = 2;
    private final SettingControl rowsOfMatchesSlider = new SettingControl("rows", 1, 10, 3, true);
    private final SettingControl upperMatchesSlider = new SettingControl("upper", 1, 10, 5, true);
    private final SettingControl lowerMatchesSlider = new SettingControl("lower", 1, 10, 1, true);
    private final SettingControl clevernessLevel = new SettingControl("level", 1, 100, 10, true);
    private final SettingControl thinkingDelay = new SettingControl("delay", 0, 60, 3, true);
    private final JCheckBox mimic = new JCheckBox("mimic", false);
    private final PlayerControl firstPlayer;
    private final PlayerControl secondPlayer;
    private final GameControl gameControl = new GameControl();
    private BufferedReader schedule = null;
    private int clockCount = 10;
    private final NimView view;
    private Nim nim = null;
    private NimPlayer player1 = null;
    private NimPlayer player2 = null;
    private NimServer server = null;
    private RemoteNimUser remote0 = null;
    private RemoteNimUser remote1 = null;
    private RemoteNimUser remote2 = null;
    private boolean swapFlag = false;
    private int clients = 0;

    public SettingsPanel(NimView nimView, boolean bl) {
        this.view = nimView;
        this.firstPlayer = new PlayerControl("player 1", 0, bl);
        this.secondPlayer = new PlayerControl("player 2", 1, bl);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1));
        jPanel.add(this.rowsOfMatchesSlider);
        jPanel.add(this.upperMatchesSlider);
        jPanel.add(this.lowerMatchesSlider);
        jPanel.add(this.gameControl);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("West", this.mimic);
        jPanel2.add("Center", this.thinkingDelay);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(4, 1));
        jPanel3.add(this.firstPlayer);
        jPanel3.add(this.secondPlayer);
        jPanel3.add(this.clevernessLevel);
        jPanel3.add(jPanel2);
        this.setLayout(new GridLayout(1, 2));
        this.add(jPanel);
        this.add(jPanel3);
    }

    public void serverUp(NimServer nimServer) {
        this.server = nimServer;
        try {
            this.schedule = new BufferedReader(new FileReader(SCHEDULE));
            StringTokenizer stringTokenizer = new StringTokenizer(this.schedule.readLine());
            this.schedule.close();
            this.clients = Integer.parseInt(stringTokenizer.nextToken());
            this.clockCount = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            this.schedule = null;
            this.clients = this.firstPlayer.playerIdx() == 0 && this.secondPlayer.playerIdx() == 0 ? 2 : (this.firstPlayer.playerIdx() == 0 || this.secondPlayer.playerIdx() == 0 ? 1 : 0);
        }
        new ConnectionsThread().start();
    }

    public void acceptClients() {
        if (this.clients == 2) {
            this.remote1 = this.server.getNimUser();
            this.remote2 = this.server.getNimUser();
        } else if (this.clients == 1) {
            this.remote0 = this.server.getNimUser();
        }
    }

    private void startGame() {
        int n = this.rowsOfMatchesSlider.value();
        int n2 = this.upperMatchesSlider.value();
        int n3 = this.lowerMatchesSlider.value();
        this.nim = new Nim(n, n2, n3);
        boolean bl = this.gameControl.isChecked();
        DelayManager delayManager = new DelayManager(this.thinkingDelay.value(), this.nim, this.mimic.isSelected());
        NimInterface nimInterface = null;
        NimInterface nimInterface2 = null;
        if (this.clients == 2) {
            if (this.firstPlayer.playerIdx() == 0 && this.secondPlayer.playerIdx() == 0) {
                if (this.swapFlag) {
                    nimInterface = this.remote2;
                    nimInterface2 = this.remote1;
                } else {
                    nimInterface = this.remote1;
                    nimInterface2 = this.remote2;
                }
                this.swapFlag = !this.swapFlag;
            } else if (this.firstPlayer.playerIdx() == 0) {
                nimInterface = this.remote1;
            } else if (this.secondPlayer.playerIdx() == 0) {
                nimInterface2 = this.remote2;
            }
        } else if (this.clients == 1) {
            if (this.firstPlayer.playerIdx() == 0 && this.secondPlayer.playerIdx() == 0) {
                if (this.swapFlag) {
                    nimInterface = this.remote0;
                    nimInterface2 = this.view;
                } else {
                    nimInterface = this.view;
                    nimInterface2 = this.remote0;
                }
                this.swapFlag = !this.swapFlag;
            } else if (this.firstPlayer.playerIdx() == 0) {
                nimInterface = this.remote0;
            } else if (this.secondPlayer.playerIdx() == 0) {
                nimInterface2 = this.remote0;
            }
        } else if (this.firstPlayer.playerIdx() == 0 && this.secondPlayer.playerIdx() == 0) {
            nimInterface = this.view;
            nimInterface2 = this.view;
        } else if (this.firstPlayer.playerIdx() == 0) {
            nimInterface = this.view;
        } else if (this.secondPlayer.playerIdx() == 0) {
            nimInterface2 = this.view;
        }
        this.player1 = this.createPlayer(this.firstPlayer, nimInterface, bl, delayManager);
        this.player2 = this.createPlayer(this.secondPlayer, nimInterface2, bl, delayManager);
        this.view.setModel(this.nim, bl);
        NimGame nimGame = new NimGame(this.nim);
        nimGame.addPlayer(this.player1);
        nimGame.addPlayer(this.player2);
        nimGame.start();
    }

    private NimPlayer createPlayer(PlayerControl playerControl, NimInterface nimInterface, boolean bl, DelayManager delayManager) {
        NimStrategy nimStrategy = null;
        switch (playerControl.playerIdx()) {
            case 0: {
                if (nimInterface != this.view) {
                    nimInterface.setModel(this.nim, bl);
                }
                nimStrategy = nimInterface.userStrategy();
                break;
            }
            case 1: {
                nimStrategy = new ScalableStrategy(bl, this.clevernessLevel.value());
                break;
            }
            case 2: {
                if (this.nim.rows() <= 5) {
                    try {
                        nimStrategy = new LearningStrategy(bl);
                        break;
                    }
                    catch (KnowledgeBase.KBException kBException) {
                        // empty catch block
                    }
                }
                nimStrategy = new ScalableStrategy(bl, this.clevernessLevel.value());
            }
        }
        return new NimPlayer(this.nim, nimStrategy, delayManager);
    }

    public void serverDown() {
        this.server = null;
        this.clients = 0;
    }

    private class ConnectionsThread
    extends Thread {
        private ConnectionsThread() {
        }

        public void run() {
            SettingsPanel.this.acceptClients();
        }
    }

    private class GameThread
    extends Thread {
        private int clock;

        private GameThread() {
        }

        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(SettingsPanel.SCHEDULE));
                String string = bufferedReader.readLine();
                SettingsPanel.this.gameControl.swtichButton(false);
                while (bufferedReader.ready()) {
                    this.clock = 0;
                    StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                    if (stringTokenizer.countTokens() < 7) break;
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    SettingsPanel.this.rowsOfMatchesSlider.setValue(n);
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    SettingsPanel.this.upperMatchesSlider.setValue(n);
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    SettingsPanel.this.lowerMatchesSlider.setValue(n);
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    SettingsPanel.this.gameControl.setChecked(n == 1);
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    SettingsPanel.this.firstPlayer.setPlayer(n);
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    SettingsPanel.this.secondPlayer.setPlayer(n);
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    if (n >= 0) {
                        SettingsPanel.this.clevernessLevel.setValue(n);
                    }
                    if ((n = Integer.parseInt(stringTokenizer.nextToken())) >= 0) {
                        SettingsPanel.this.thinkingDelay.setValue(n);
                    }
                    if ((n = Integer.parseInt(stringTokenizer.nextToken())) >= 0) {
                        SettingsPanel.this.mimic.setSelected(n == 1);
                    }
                    SettingsPanel.this.startGame();
                    this.timing();
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                SettingsPanel.this.startGame();
            }
            SettingsPanel.this.gameControl.swtichButton(true);
        }

        private void timing() {
            do {
                this.delay();
                if (!SettingsPanel.this.nim.over()) continue;
                ++this.clock;
            } while (this.clock < SettingsPanel.this.clockCount);
        }

        private void delay() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class GameControl
    extends JPanel
    implements ActionListener {
        private final JCheckBox checkBox = new JCheckBox("reverse", false);
        private final JButton button = new JButton("new game");

        public GameControl() {
            this.setLayout(new GridLayout(1, 2));
            this.add(this.checkBox);
            this.add(this.button);
            this.button.addActionListener(this);
        }

        public boolean isChecked() {
            return this.checkBox.isSelected();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SettingsPanel.this.nim == null || SettingsPanel.this.nim.over()) {
                new GameThread().start();
            }
        }

        private void setChecked(boolean bl) {
            this.checkBox.setSelected(bl);
        }

        private void swtichButton(boolean bl) {
            this.button.setEnabled(bl);
        }
    }

    private class PlayerControl
    extends JPanel
    implements ItemListener {
        private final JComboBox choice = new JComboBox();

        public PlayerControl(String string, int n, boolean bl) {
            this.choice.addItem(PLAYER[0]);
            this.choice.addItem(PLAYER[1]);
            if (!bl) {
                this.choice.addItem(PLAYER[2]);
            }
            this.choice.setSelectedIndex(n);
            this.setLayout(new GridLayout(1, 2));
            this.add(new JLabel(string + ": ", 0));
            this.add(this.choice);
            this.choice.addItemListener(this);
        }

        public int playerIdx() {
            return this.choice.getSelectedIndex();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = SettingsPanel.this.firstPlayer.playerIdx() != 0 || SettingsPanel.this.secondPlayer.playerIdx() != 0;
            SettingsPanel.this.clevernessLevel.setEnabled(bl);
            SettingsPanel.this.thinkingDelay.setEnabled(bl);
        }

        private void setPlayer(int n) {
            this.choice.setSelectedIndex(n);
        }
    }

    private class SettingControl
    extends JPanel
    implements ChangeListener {
        private final JLabel header = new JLabel("", 0);
        private final String idf;
        private final JSlider slider;

        public SettingControl(String string, int n, int n2, int n3, boolean bl) {
            this.idf = string;
            this.slider = new JSlider(n, n2, n3);
            this.updateHeader();
            this.setLayout(new GridLayout(1, 2));
            this.add(this.header);
            this.add(this.slider);
            this.slider.addChangeListener(this);
            this.slider.setEnabled(bl);
        }

        public int value() {
            return this.slider.getValue();
        }

        public void setEnabled(boolean bl) {
            this.slider.setEnabled(bl);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.updateHeader();
        }

        private void updateHeader() {
            this.header.setText(this.idf + ": " + this.slider.getValue() + " ");
        }

        private void setValue(int n) {
            this.slider.setValue(n);
        }
    }
}

