/*
 * Decompiled with CFR 0.152.
 */
package nim;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import javax.swing.JPanel;
import nim.Nim;
import nim.NimInterface;
import nim.NimStarter;
import nim.NimStrategy;

public class NimView
extends JPanel
implements NimInterface {
    private static final String IMGFOLDER = "images/";
    private static final String MTCH = "images/match.png";
    private static final String LBUG = "images/ladybug.gif";
    private static final String HAPP = "images/happy.gif";
    private static final String ANGR = "images/angry.gif";
    private static final double MFCT = 0.1;
    private static final Color BG = new Color(0.0f, 0.0f, 0.5f);
    private static final Color LS = new Color(0.4f, 0.0f, 0.1f);
    private static final Color FG = Color.orange;
    private static final Color RS = new Color(0.8f, 0.0f, 0.0f);
    private static final Color GS = new Color(0.0f, 0.8f, 0.0f);
    private static final int REFRESH_T = 10;
    private final Image match;
    private final Image ladybug;
    private final Image happy;
    private final Image angry;
    private Nim nim = null;
    private boolean reverseGame;
    private UserStrategy strategy = null;
    private int rows;
    private int columns;
    private GridItem selection = null;
    private boolean validSelection = false;
    private float columnWidth;
    private float rowHeight;
    private boolean userPlays;
    private boolean userWins;
    private boolean userTurn = false;

    public NimView(NimStarter.ImageLoader imageLoader) {
        this.setBackground(BG);
        this.match = imageLoader.getImage(this, MTCH);
        this.ladybug = imageLoader.getImage(this, LBUG);
        this.happy = imageLoader.getImage(this, HAPP);
        this.angry = imageLoader.getImage(this, ANGR);
    }

    public void setModel(Nim nim, boolean bl) {
        this.nim = nim;
        this.reverseGame = bl;
        this.rows = nim.rows();
        this.columns = nim.available(0);
        for (int i = 1; i < nim.rows(); ++i) {
            if (this.columns >= nim.available(i)) continue;
            this.columns = nim.available(i);
        }
        this.columns += 2;
        this.userPlays = false;
        this.userWins = false;
        this.selection = null;
        this.repaint(10L);
        nim.addObserver(this);
    }

    public NimStrategy userStrategy() {
        if (this.strategy == null) {
            this.strategy = new UserStrategy();
        }
        return this.strategy;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Nim.Move) {
            Nim.Move move = (Nim.Move)object;
            this.selection = new GridItem(move.row, this.nim.available(move.row) - move.amount);
            this.validSelection = true;
        } else {
            this.validSelection = false;
        }
        this.repaint(10L);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(BG);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.nim == null) {
            this.drawLadybug(this.ladybug, graphics);
        } else if (this.nim.over()) {
            if (!this.userPlays) {
                this.writeGameOver(graphics);
            } else if (this.userWins) {
                this.drawLadybug(this.happy, graphics);
            } else {
                this.drawLadybug(this.angry, graphics);
            }
        } else {
            this.drawView(graphics);
        }
    }

    private void drawView(Graphics graphics) {
        int n;
        int n2;
        int n3;
        this.columnWidth = (float)this.getWidth() / (float)this.columns;
        this.rowHeight = (float)this.getHeight() / (float)this.rows;
        int n4 = (int)(0.8 * (double)this.rowHeight);
        int n5 = (int)(0.1 * (double)n4);
        for (n3 = 0; n3 < this.rows; ++n3) {
            n2 = (int)(((double)n3 + 0.1) * (double)this.rowHeight);
            for (int i = 0; i < this.nim.available(n3); ++i) {
                n = (int)(((double)i + 0.45) * (double)this.columnWidth);
                if (this.reverseGame && this.nim.available() == 1) {
                    graphics.setColor(LS);
                    graphics.fillOval((int)(((double)i + 0.1) * (double)this.columnWidth), n2, (int)(0.8 * (double)this.columnWidth), n4);
                    graphics.setColor(BG);
                }
                graphics.drawImage(this.match, n, n2, n5, n4, this);
            }
        }
        if (this.validSelection) {
            n3 = this.nim.available(this.selection.i);
            n = (int)(((double)this.selection.j + 0.25) * (double)this.columnWidth);
            int n6 = (int)(((double)n3 - 0.25) * (double)this.columnWidth);
            n2 = (int)(((double)this.selection.i + 0.05) * (double)this.rowHeight);
            n4 = (int)(0.9 * (double)this.rowHeight);
            n5 = n6 - n;
            graphics.setColor(FG);
            graphics.drawRect(n, n2, n5, n4);
            graphics.drawRect(n + 1, n2 + 1, n5 - 2, n4 - 2);
        }
        n3 = (int)(0.3 * (double)Math.min(this.columnWidth, this.rowHeight));
        n = (int)(((double)this.columns - 0.65) * (double)this.columnWidth);
        n2 = (int)(0.4 * (double)this.rowHeight - (double)n3);
        graphics.setColor(RS);
        if (this.userTurn) {
            graphics.drawOval(n, n2, n3, n3);
        } else {
            graphics.fillOval(n, n2, n3, n3);
        }
        n2 = (int)(0.6 * (double)this.rowHeight);
        graphics.setColor(GS);
        if (this.userTurn) {
            graphics.fillOval(n, n2, n3, n3);
        } else {
            graphics.drawOval(n, n2, n3, n3);
        }
    }

    private void drawLadybug(Image image, Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = (n - 244) / 2;
        int n4 = Math.max(n2 - 280, 0);
        graphics.drawImage(image, n3, n4, 244, 278, this);
    }

    private void writeGameOver(Graphics graphics) {
        graphics.setColor(FG);
        graphics.setFont(new Font("Arial", 1, 20));
        graphics.drawString("Game Over", this.getWidth() / 2 - 48, this.getHeight() / 2);
    }

    private static class GridItem {
        public final int i;
        public final int j;

        public GridItem(int n, int n2) {
            this.i = n;
            this.j = n2;
        }

        public boolean equals(GridItem gridItem) {
            if (gridItem == null) {
                return false;
            }
            return gridItem.i == this.i && gridItem.j == this.j;
        }
    }

    private class UserStrategy
    implements NimStrategy,
    MouseListener,
    MouseMotionListener {
        private UserStrategy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Nim.Move suggest(Nim nim) {
            NimView.this.userPlays = true;
            Nim.Move move = null;
            UserStrategy userStrategy = this;
            synchronized (userStrategy) {
                int n;
                NimView.this.addMouseListener(this);
                NimView.this.addMouseMotionListener(this);
                NimView.this.userTurn = true;
                NimView.this.repaint(10L, (int)((float)(NimView.this.columns - 1) * NimView.this.columnWidth), 0, (int)NimView.this.columnWidth, (int)NimView.this.rowHeight);
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                NimView.this.userTurn = false;
                NimView.this.repaint(10L, (int)((float)(NimView.this.columns - 1) * NimView.this.columnWidth), 0, (int)NimView.this.columnWidth, (int)NimView.this.rowHeight);
                NimView.this.removeMouseListener(this);
                NimView.this.removeMouseMotionListener(this);
                if (NimView.this.selection != null && (n = nim.available(((NimView)NimView.this).selection.i) - ((NimView)NimView.this).selection.j) > 0) {
                    move = new Nim.Move(((NimView)NimView.this).selection.i, n);
                    NimView.this.userWins = NimView.this.reverseGame ? nim.available() == n + 1 : nim.available() == n;
                }
            }
            return move;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            NimView.this.selection = this.getItem(mouseEvent.getX(), mouseEvent.getY());
            NimView.this.validSelection = ((NimView)NimView.this).selection.j >= 0 && ((NimView)NimView.this).selection.j < NimView.this.nim.available(((NimView)NimView.this).selection.i);
            NimView.this.repaint(10L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            UserStrategy userStrategy = this;
            synchronized (userStrategy) {
                if (NimView.this.validSelection) {
                    this.notify();
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            GridItem gridItem = this.getItem(mouseEvent.getX(), mouseEvent.getY());
            if (!gridItem.equals(NimView.this.selection)) {
                NimView.this.selection = gridItem;
                NimView.this.validSelection = ((NimView)NimView.this).selection.j >= 0 && ((NimView)NimView.this).selection.j < NimView.this.nim.available(((NimView)NimView.this).selection.i);
                NimView.this.repaint(10L);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private GridItem getItem(int n, int n2) {
            int n3 = Math.min((int)((float)n2 / NimView.this.rowHeight), NimView.this.rows - 1);
            int n4 = Math.min((int)((float)n / NimView.this.columnWidth), NimView.this.columns - 1);
            return new GridItem(n3, n4);
        }
    }
}

