/*
 * Decompiled with CFR 0.152.
 */
package nim;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import nim.NetworkMonitor;
import nim.Nim;
import nim.NimInterface;
import nim.NimStrategy;
import nim.RemoteAck;
import nim.RemoteSetModel;
import nim.RemoteSuggest;
import nim.RemoteUpdate;
import nim.Transceiver;

public class NimClient {
    private static final int TIMEOUT = 900000;
    private static final boolean FOREVER = true;
    private final NimProxy proxy = new NimProxy();
    private final NimInterface view;
    private final NimStrategy strategy;
    private final NetworkMonitor monitor;

    public NimClient(NimInterface nimInterface, NetworkMonitor networkMonitor) {
        this.view = nimInterface;
        this.strategy = nimInterface.userStrategy();
        this.monitor = networkMonitor;
    }

    public NimClient(NimInterface nimInterface) {
        this(nimInterface, null);
    }

    public boolean startSession(String string) {
        this.trace("starting client session");
        try {
            Socket socket = new Socket(InetAddress.getByName(string), 5321);
            this.trace("session started");
            ClientSession clientSession = new ClientSession(socket, this.monitor);
            return true;
        }
        catch (IOException iOException) {
            this.trace("exception caught: " + iOException);
            this.trace("client session not running");
            return false;
        }
    }

    private void trace(String string) {
        if (this.monitor != null) {
            this.monitor.display(string);
        }
    }

    private static class NimProxy
    extends Nim {
        private Nim nim = null;

        public NimProxy() {
            super(0);
        }

        public void encapsulate(Nim nim) {
            this.nim = nim;
        }

        public int rows() {
            return this.nim.rows();
        }

        public int available(int n) {
            return this.nim.available(n);
        }

        public int available() {
            return this.nim.available();
        }

        public boolean over() {
            return this.nim.over();
        }

        public void take(int n, int n2) {
        }
    }

    private class ClientSession
    extends Transceiver
    implements Runnable {
        public ClientSession(Socket socket, NetworkMonitor networkMonitor) {
            super(socket, 900000, networkMonitor);
            new Thread(this).start();
        }

        public ClientSession(Socket socket) {
            this(socket, null);
        }

        public void run() {
            while (true) {
                Nim nim;
                Object object;
                if ((object = this.receive()) instanceof RemoteSetModel) {
                    NimClient.this.proxy.encapsulate(((RemoteSetModel)object).nim);
                    NimClient.this.view.setModel(NimClient.this.proxy, ((RemoteSetModel)object).reverseGame);
                    this.send(new RemoteAck());
                    continue;
                }
                if (object instanceof RemoteUpdate) {
                    nim = (Nim)((RemoteUpdate)object).obs;
                    if (((RemoteUpdate)object).obj == null) {
                        NimClient.this.proxy.encapsulate(nim);
                    }
                    NimClient.this.view.update(NimClient.this.proxy, ((RemoteUpdate)object).obj);
                    continue;
                }
                if (object instanceof RemoteSuggest) {
                    nim = ((RemoteSuggest)object).nim;
                    this.send(NimClient.this.strategy.suggest(NimClient.this.proxy));
                    continue;
                }
                if (object != null) continue;
                System.exit(0);
            }
        }
    }
}

