/*
 * Decompiled with CFR 0.152.
 */
package nim;

import java.util.Random;
import nim.ComputerStrategy;
import nim.KnowledgeBase;
import nim.Nim;

public class LearningStrategy
implements ComputerStrategy {
    private static final int NIM_ROWS = 5;
    private static final int NO_ITEM = 0;
    private static final int SIZE = 50;
    private static final int MYSELF = 0;
    private static final int OPPONENT = 1;
    private final KnowledgeBase kb;
    private final Random random = new Random();
    private final int[][] item = new int[2][50];
    private final boolean reverseGame;
    private int p = 0;
    private int q = 0;

    public LearningStrategy(boolean bl) throws KnowledgeBase.KBException {
        this.kb = new KnowledgeBase();
        this.reverseGame = bl;
    }

    public Nim.Move suggest(Nim nim) {
        int n;
        int n2;
        if (nim.over()) {
            return null;
        }
        int[] nArray = LearningStrategy.nimTuple(nim);
        this.item[1][this.q] = this.kb.addItem(nArray);
        ++this.q;
        int n3 = Math.abs(this.random.nextInt()) % nim.rows();
        while (nim.available(n3) == 0) {
            n3 = (n3 + 1) % nim.rows();
        }
        if (nArray[1] == 0) {
            if (this.reverseGame && nArray[0] > 1) {
                n2 = nArray[0] - 1;
                nArray[0] = 1;
            } else {
                n2 = nArray[0];
                nArray[0] = 0;
            }
            n = this.kb.addItem(nArray);
        } else {
            int[] nArray2 = new int[5];
            n = this.kb.targetItem(nArray, nArray2);
            if (n == 0) {
                n2 = Math.abs(this.random.nextInt()) % nim.available(n3) + 1;
                LearningStrategy.tupleTransition(nArray, nim.available(n3), nim.available(n3) - n2);
                n = this.kb.addItem(nArray);
            } else {
                int n4 = LearningStrategy.unpairedSize(nArray, nArray2);
                n3 = LearningStrategy.targetRow(nim, n4);
                n2 = nim.available() - LearningStrategy.all(nArray2);
                nArray = nArray2;
            }
        }
        this.item[0][this.p] = n;
        ++this.p;
        this.learningTrack(nArray);
        return new Nim.Move(n3, n2);
    }

    private void learningTrack(int[] nArray) {
        if (this.reverseGame && nArray[0] == 1 && nArray[1] == 0 || !this.reverseGame && nArray[0] == 0) {
            int n;
            for (n = 0; n < this.p; ++n) {
                this.kb.updateItem(this.item[0][n], true);
            }
            for (n = 0; n < this.q; ++n) {
                this.kb.updateItem(this.item[1][n], false);
            }
            this.kb.close();
        } else if (this.reverseGame && nArray[0] == 0 || !this.reverseGame && nArray[0] > 0 && nArray[1] == 0) {
            int n;
            for (n = 0; n < this.p; ++n) {
                this.kb.updateItem(this.item[0][n], false);
            }
            for (n = 0; n < this.q; ++n) {
                this.kb.updateItem(this.item[1][n], true);
            }
            this.kb.close();
        }
    }

    private static int[] nimTuple(Nim nim) {
        int[] nArray = new int[5];
        for (int i = 0; i < 5; ++i) {
            if (i < nim.rows()) {
                int n = nim.available(i);
                for (int j = i; j > 0 && n > nArray[j - 1]; --j) {
                    nArray[j] = nArray[j - 1];
                }
                nArray[j] = n;
                continue;
            }
            nArray[i] = 0;
        }
        return nArray;
    }

    private static void tupleTransition(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (nArray[n3] > n) {
            ++n3;
        }
        for (int i = n3 + 1; i < 5 && n2 < nArray[i]; ++i) {
            nArray[i - 1] = nArray[i];
        }
        nArray[i - 1] = n2;
    }

    private static int unpairedSize(int[] nArray, int[] nArray2) {
        int n = 0;
        while (nArray2[n] == nArray[n]) {
            ++n;
        }
        return nArray[n];
    }

    private static int targetRow(Nim nim, int n) {
        int n2 = 0;
        while (nim.available(n2) != n) {
            ++n2;
        }
        return n2;
    }

    private static int all(int[] nArray) {
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            n += nArray[i];
        }
        return n;
    }
}

