/*
 * Decompiled with CFR 0.152.
 */
package nim;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class KnowledgeBase {
    public static final int NIM_ROWS = 5;
    public static final int NO_ITEM = 0;
    private static final String JDBC_DRIVER = "smallsql.database.SSDriver";
    private static final String DB_PATH = "knowledge_base";
    private static final String JDBC_URL = "jdbc:smallsql:knowledge_base";
    private static final String JDBC_NEW = "jdbc:smallsql:knowledge_base?create=true";
    private static final String NEW_TABLE = KnowledgeBase.newTableStm();
    private static final String NEW_VIEW = KnowledgeBase.newViewStm();
    private static final String INS_PATTERN = KnowledgeBase.insPatternStm();
    private static final String WON_PATTERN = "UPDATE Arrangements SET Won  = Won+1  WHERE Item = ?";
    private static final String LOS_PATTERN = "UPDATE Arrangements SET Lost = Lost+1 WHERE Item = ?";
    private static final String KEY_QUERY = "SELECT MAX( Item ) AS Last FROM Arrangements";
    private static final String FND_PATTERN = KnowledgeBase.findPatternStm();
    private static final String DST_PATTERN = KnowledgeBase.destPatternStm();
    private final PreparedStatement insStm;
    private final PreparedStatement wonStm;
    private final PreparedStatement losStm;
    private final PreparedStatement fndQry;
    private final PreparedStatement dstQry;
    private Connection connection;
    private int itmKey = 0;

    public KnowledgeBase() throws KBException {
        this.openDBConnection();
        try {
            this.insStm = this.connection.prepareStatement(INS_PATTERN);
            this.wonStm = this.connection.prepareStatement(WON_PATTERN);
            this.losStm = this.connection.prepareStatement(LOS_PATTERN);
            this.fndQry = this.connection.prepareStatement(FND_PATTERN);
            this.dstQry = this.connection.prepareStatement(DST_PATTERN);
            KnowledgeBase.writeln("statements prepared");
        }
        catch (SQLException sQLException) {
            KnowledgeBase.writeln("caught exception: " + sQLException);
            KnowledgeBase.writeln("unable to prepare all statements");
            throw new KBException();
        }
    }

    public void close() {
        try {
            this.insStm.close();
            this.wonStm.close();
            this.losStm.close();
            this.fndQry.close();
            this.dstQry.close();
            KnowledgeBase.writeln("statements resources released");
        }
        catch (SQLException sQLException) {
            KnowledgeBase.writeln("caught exception: " + sQLException);
            KnowledgeBase.writeln("unable to close all statements");
        }
        try {
            this.connection.close();
            KnowledgeBase.writeln("connection closed");
        }
        catch (SQLException sQLException) {
            KnowledgeBase.writeln("caught exception: " + sQLException);
            KnowledgeBase.writeln("unable to close connection");
        }
    }

    public int addItem(int[] nArray) {
        int n = this.findDB(nArray);
        if (n == 0) {
            n = this.insertDB(nArray);
            KnowledgeBase.writeln("item " + n + " found/inserted");
        }
        return n;
    }

    public void updateItem(int n, boolean bl) {
        PreparedStatement preparedStatement = bl ? this.wonStm : this.losStm;
        try {
            preparedStatement.clearParameters();
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
            KnowledgeBase.writeln("item " + n + " updated (if found)");
        }
        catch (SQLException sQLException) {
            KnowledgeBase.writeln("caught exception: " + sQLException);
            KnowledgeBase.writeln("unable to update item");
        }
    }

    public int targetItem(int[] nArray, int[] nArray2) {
        int n;
        int n2 = 0;
        for (n = 0; n < 5; ++n) {
            n2 += nArray[n];
        }
        try {
            this.dstQry.clearParameters();
            this.dstQry.setInt(1, n2);
            for (n = 0; n < 5; ++n) {
                this.dstQry.setInt(n + 2, nArray[n]);
            }
            n = KnowledgeBase.chooseBestCandidate(this.dstQry, nArray, nArray2);
            if (n == 0) {
                KnowledgeBase.writeln("no target item");
            } else {
                KnowledgeBase.writeln("chosen target item: " + n);
            }
            return n;
        }
        catch (SQLException sQLException) {
            KnowledgeBase.writeln("caught exception: " + sQLException);
            KnowledgeBase.writeln("unable to process item");
            return 0;
        }
    }

    private void openDBConnection() throws KBException {
        try {
            Class.forName(JDBC_DRIVER);
        }
        catch (ClassNotFoundException classNotFoundException) {
            KnowledgeBase.writeln("caught exception: " + classNotFoundException);
            KnowledgeBase.writeln("add smallsql to class paths, e.g.: java -classpath \"smallsql.jar:.\" JDBCTrial");
            throw new KBException();
        }
        try {
            this.connection = DriverManager.getConnection(JDBC_URL);
            this.setMaxItemKey();
            KnowledgeBase.writeln("connected to database at URL: jdbc:smallsql:knowledge_base");
        }
        catch (SQLException sQLException) {
            try {
                this.connection = DriverManager.getConnection(JDBC_NEW);
                KnowledgeBase.writeln("new database created");
                this.connection.setAutoCommit(true);
                this.create(NEW_TABLE);
                this.create(NEW_VIEW);
                KnowledgeBase.writeln("table and view created");
            }
            catch (SQLException sQLException2) {
                KnowledgeBase.writeln("caught exception: " + sQLException2);
                KnowledgeBase.writeln("unable to access/create database");
                throw new KBException();
            }
        }
    }

    private void create(String string) throws SQLException {
        Statement statement = this.connection.createStatement();
        statement.executeUpdate(string);
        statement.close();
    }

    private void setMaxItemKey() {
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(KEY_QUERY);
            if (resultSet.next()) {
                this.itmKey = resultSet.getInt("Last");
                KnowledgeBase.writeln("max item: " + this.itmKey);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            KnowledgeBase.writeln("caught exception: " + sQLException);
            KnowledgeBase.writeln("unable to restore max item key");
        }
    }

    private int findDB(int[] nArray) {
        int n = 0;
        try {
            this.fndQry.clearParameters();
            for (int i = 0; i < 5; ++i) {
                this.fndQry.setInt(i + 1, nArray[i]);
            }
            ResultSet resultSet = this.fndQry.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt("Item");
                KnowledgeBase.writeln("item found: " + n);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            KnowledgeBase.writeln("caught exception: " + sQLException);
            KnowledgeBase.writeln("unable to process item");
        }
        return n;
    }

    private int insertDB(int[] nArray) {
        try {
            this.insStm.clearParameters();
            for (int i = 0; i < 5; ++i) {
                this.insStm.setInt(i + 1, nArray[i]);
            }
            ++this.itmKey;
            this.insStm.setInt(6, this.itmKey);
            this.insStm.executeUpdate();
            KnowledgeBase.writeln("insert done");
            return this.itmKey;
        }
        catch (SQLException sQLException) {
            KnowledgeBase.writeln("caught exception: " + sQLException);
            KnowledgeBase.writeln("unable to insert item");
            return 0;
        }
    }

    private static int chooseBestCandidate(PreparedStatement preparedStatement, int[] nArray, int[] nArray2) throws SQLException {
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 0;
        int n2 = 0;
        int[] nArray3 = new int[5];
        KnowledgeBase.writeln("result set:");
        while (resultSet.next()) {
            int n3;
            int n4 = resultSet.getInt("Item");
            int n5 = resultSet.getInt("Weight");
            for (n3 = 0; n3 < 5; ++n3) {
                nArray3[n3] = resultSet.getInt("Row" + n3);
            }
            if (n5 > n2 && KnowledgeBase.compatible(nArray, nArray3)) {
                n = n4;
                n2 = n5;
                for (n3 = 0; n3 < 5; ++n3) {
                    nArray2[n3] = nArray3[n3];
                }
            }
            String string = "item <" + resultSet.getInt("Row0");
            for (int i = 1; i < 5; ++i) {
                string = string + ", " + resultSet.getInt("Row" + i);
            }
            string = string + ">";
            KnowledgeBase.writeln("Won=" + resultSet.getInt("Won") + ", Lost=" + resultSet.getInt("Lost") + ", Weight=" + n5 + ", Rows=" + string + " : Together=" + resultSet.getInt("Together") + ", Item=" + n4);
        }
        resultSet.close();
        return n;
    }

    private static boolean compatible(int[] nArray, int[] nArray2) {
        int n;
        for (n = 0; n < 5 && nArray2[n] == nArray[n]; ++n) {
        }
        ++n;
        while (n < 5 && nArray2[n - 1] == nArray[n]) {
            ++n;
        }
        while (n < 5 && nArray2[n] == nArray[n]) {
            ++n;
        }
        return n == 5;
    }

    private static String newTableStm() {
        String string = "CREATE TABLE Arrangements ( Won INT DEFAULT 0, Lost INT DEFAULT 0, ";
        for (int i = 0; i < 5; ++i) {
            string = string + "Row" + i + " INT DEFAULT 0, ";
        }
        string = string + "Item INT NOT NULL, PRIMARY KEY (Item) )";
        KnowledgeBase.writeln(string);
        return string;
    }

    private static String newViewStm() {
        int n;
        String string = "CREATE VIEW ArrangementsView AS SELECT Won, Lost, ( 100 * (Won - Lost) / (Won + Lost + 1) ) AS Weight, ";
        for (n = 0; n < 5; ++n) {
            string = string + "Row" + n + ", ";
        }
        string = string + "( Row0 ";
        for (n = 1; n < 5; ++n) {
            string = string + "+ Row" + n + " ";
        }
        string = string + ") AS Together, Item FROM Arrangements";
        KnowledgeBase.writeln(string);
        return string;
    }

    private static String insPatternStm() {
        String string = "INSERT INTO Arrangements VALUES ( 0, 0, ";
        for (int i = 0; i < 5; ++i) {
            string = string + "?, ";
        }
        string = string + "? )";
        KnowledgeBase.writeln(string);
        return string;
    }

    private static String findPatternStm() {
        String string = "SELECT * FROM Arrangements WHERE ( Row0 = ? ) ";
        for (int i = 1; i < 5; ++i) {
            string = string + " AND ( Row" + i + " = ? )";
        }
        KnowledgeBase.writeln(string);
        return string;
    }

    private static String destPatternStm() {
        String string = "SELECT * FROM ArrangementsView WHERE ( Together < ? )";
        for (int i = 0; i < 5; ++i) {
            string = string + " AND ( Row" + i + " <= ? )";
        }
        KnowledgeBase.writeln(string);
        return string;
    }

    private static void writeln(String string) {
    }

    public static class KBException
    extends Exception {
    }
}

