/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.Expression;
import smallsql.database.RowSource;

class Where
extends RowSource {
    private final RowSource rowSource;
    private final Expression where;
    private int row = 0;
    private boolean isCurrentRow;

    Where(RowSource rowSource, Expression expression) {
        this.rowSource = rowSource;
        this.where = expression;
    }

    RowSource getFrom() {
        return this.rowSource;
    }

    private final boolean isValidRow() throws Exception {
        return this.where == null || this.rowSource.rowInserted() || this.where.getBoolean();
    }

    final boolean isScrollable() {
        return this.rowSource.isScrollable();
    }

    final boolean isBeforeFirst() {
        return this.row == 0;
    }

    final boolean isFirst() {
        return this.row == 1 && this.isCurrentRow;
    }

    final boolean isLast() throws Exception {
        if (!this.isCurrentRow) {
            return false;
        }
        long l = this.rowSource.getRowPosition();
        boolean bl = this.next();
        this.rowSource.setRowPosition(l);
        return !bl;
    }

    final boolean isAfterLast() {
        return this.row > 0 && !this.isCurrentRow;
    }

    final void beforeFirst() throws Exception {
        this.rowSource.beforeFirst();
        this.row = 0;
    }

    final boolean first() throws Exception {
        this.isCurrentRow = this.rowSource.first();
        while (this.isCurrentRow && !this.isValidRow()) {
            this.isCurrentRow = this.rowSource.next();
        }
        this.row = 1;
        return this.isCurrentRow;
    }

    final boolean previous() throws Exception {
        boolean bl = this.isCurrentRow;
        do {
            this.isCurrentRow = this.rowSource.previous();
        } while (this.isCurrentRow && !this.isValidRow());
        if (bl || this.isCurrentRow) {
            --this.row;
        }
        return this.isCurrentRow;
    }

    final boolean next() throws Exception {
        boolean bl = this.isCurrentRow;
        do {
            this.isCurrentRow = this.rowSource.next();
        } while (this.isCurrentRow && !this.isValidRow());
        if (bl || this.isCurrentRow) {
            ++this.row;
        }
        return this.isCurrentRow;
    }

    final boolean last() throws Exception {
        while (this.next()) {
        }
        return this.previous();
    }

    final void afterLast() throws Exception {
        while (this.next()) {
        }
    }

    final int getRow() throws Exception {
        return this.isCurrentRow ? this.row : 0;
    }

    final long getRowPosition() {
        return this.rowSource.getRowPosition();
    }

    final void setRowPosition(long l) throws Exception {
        this.rowSource.setRowPosition(l);
    }

    final void nullRow() {
        this.rowSource.nullRow();
        this.row = 0;
    }

    final void noRow() {
        this.rowSource.noRow();
        this.row = 0;
    }

    final boolean rowInserted() {
        return this.rowSource.rowInserted();
    }

    final boolean rowDeleted() {
        return this.rowSource.rowDeleted();
    }

    final void execute() throws Exception {
        this.rowSource.execute();
    }
}

