/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import smallsql.database.CommandSelect;
import smallsql.database.Expression;
import smallsql.database.Expressions;
import smallsql.database.MutableNumeric;
import smallsql.database.SSConnection;
import smallsql.database.TableView;
import smallsql.database.TableViewResult;
import smallsql.database.Utils;
import smallsql.database.View;

class ViewResult
extends TableViewResult {
    private final View view;
    private final Expressions columnExpressions;
    private final CommandSelect commandSelect;

    ViewResult(View view) {
        this.view = view;
        this.columnExpressions = view.commandSelect.columnExpressions;
        this.commandSelect = view.commandSelect;
    }

    ViewResult(SSConnection sSConnection, CommandSelect commandSelect) throws SQLException {
        try {
            this.view = new View(sSConnection, commandSelect);
            this.columnExpressions = commandSelect.columnExpressions;
            this.commandSelect = commandSelect;
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    boolean init(SSConnection sSConnection) throws Exception {
        if (super.init(sSConnection)) {
            this.commandSelect.compile(sSConnection);
            return true;
        }
        return false;
    }

    TableView getTableView() {
        return this.view;
    }

    void deleteRow() throws SQLException {
        this.commandSelect.deleteRow(this.con);
    }

    void updateRow(Expression[] expressionArray) throws Exception {
        this.commandSelect.updateRow(this.con, expressionArray);
    }

    void insertRow(Expression[] expressionArray) throws Exception {
        this.commandSelect.insertRow(this.con, expressionArray);
    }

    boolean isNull(int n) throws Exception {
        return this.columnExpressions.get(n).isNull();
    }

    boolean getBoolean(int n) throws Exception {
        return this.columnExpressions.get(n).getBoolean();
    }

    int getInt(int n) throws Exception {
        return this.columnExpressions.get(n).getInt();
    }

    long getLong(int n) throws Exception {
        return this.columnExpressions.get(n).getLong();
    }

    float getFloat(int n) throws Exception {
        return this.columnExpressions.get(n).getFloat();
    }

    double getDouble(int n) throws Exception {
        return this.columnExpressions.get(n).getDouble();
    }

    long getMoney(int n) throws Exception {
        return this.columnExpressions.get(n).getMoney();
    }

    MutableNumeric getNumeric(int n) throws Exception {
        return this.columnExpressions.get(n).getNumeric();
    }

    Object getObject(int n) throws Exception {
        return this.columnExpressions.get(n).getObject();
    }

    String getString(int n) throws Exception {
        return this.columnExpressions.get(n).getString();
    }

    byte[] getBytes(int n) throws Exception {
        return this.columnExpressions.get(n).getBytes();
    }

    int getDataType(int n) {
        return this.columnExpressions.get(n).getDataType();
    }

    void beforeFirst() throws Exception {
        this.commandSelect.beforeFirst();
    }

    boolean isBeforeFirst() throws SQLException {
        return this.commandSelect.isBeforeFirst();
    }

    boolean isFirst() throws SQLException {
        return this.commandSelect.isFirst();
    }

    boolean first() throws Exception {
        return this.commandSelect.first();
    }

    boolean previous() throws Exception {
        return this.commandSelect.previous();
    }

    boolean next() throws Exception {
        return this.commandSelect.next();
    }

    boolean last() throws Exception {
        return this.commandSelect.last();
    }

    boolean isLast() throws Exception {
        return this.commandSelect.isLast();
    }

    boolean isAfterLast() throws Exception {
        return this.commandSelect.isAfterLast();
    }

    void afterLast() throws Exception {
        this.commandSelect.afterLast();
    }

    boolean absolute(int n) throws Exception {
        return this.commandSelect.absolute(n);
    }

    boolean relative(int n) throws Exception {
        return this.commandSelect.relative(n);
    }

    int getRow() throws Exception {
        return this.commandSelect.getRow();
    }

    long getRowPosition() {
        return this.commandSelect.join.getRowPosition();
    }

    void setRowPosition(long l) throws Exception {
        this.commandSelect.join.setRowPosition(l);
    }

    final boolean rowInserted() {
        return this.commandSelect.join.rowInserted();
    }

    final boolean rowDeleted() {
        return this.commandSelect.join.rowDeleted();
    }

    void nullRow() {
        this.commandSelect.join.nullRow();
    }

    void noRow() {
        this.commandSelect.join.noRow();
    }

    final void execute() throws Exception {
        this.commandSelect.join.execute();
    }
}

