/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import java.text.MessageFormat;
import smallsql.database.CommandSelect;
import smallsql.database.DataSource;
import smallsql.database.Database;
import smallsql.database.ExpressionName;
import smallsql.database.MemoryResult;
import smallsql.database.SSConnection;
import smallsql.database.SmallSQLException;

class Utils {
    static final String MASTER_FILENAME = "smallsql.master";
    static final String TABLE_VIEW_EXTENTION = ".sdb";
    private static final String LOB_EXTENTION = ".lob";
    static final String IDX_EXTENTION = ".idx";
    private static final Integer[] integerCache = new Integer[260];
    private static final Short[] shortCache = new Short[260];
    static final char[] digits;

    Utils() {
    }

    static SQLException createUnsupportedException(String string) {
        return new SmallSQLException("Unsupported Operation " + string, "01000", 0);
    }

    static SQLException createSQLException(String string) {
        return new SmallSQLException(string, "01000", 0);
    }

    static SQLException createSQLException(String string, Object object) {
        string = MessageFormat.format(string, object);
        return new SmallSQLException(string, "01000", 0);
    }

    static SQLException createSQLException(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return (SQLException)throwable;
        }
        return new SmallSQLException(throwable);
    }

    static SQLException createSQLException(String string, Throwable throwable) {
        SmallSQLException smallSQLException = new SmallSQLException(string, "01000", 0);
        smallSQLException.initCause(throwable);
        return smallSQLException;
    }

    static String createTableViewFileName(Database database, String string) {
        return database.getName() + '/' + string + TABLE_VIEW_EXTENTION;
    }

    static String createLobFileName(Database database, String string) {
        return database.getName() + '/' + string + LOB_EXTENTION;
    }

    static String createIdxFileName(Database database, String string) {
        return database.getName() + '/' + string + IDX_EXTENTION;
    }

    static boolean like(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string2.length() == 0) {
            return true;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        block4: while (string2.length() > n && string.length() > n2) {
            char c = Character.toUpperCase(string2.charAt(n++));
            switch (c) {
                case '%': {
                    bl = true;
                    continue block4;
                }
                case '_': {
                    ++n2;
                    continue block4;
                }
            }
            if (bl) {
                while (n2 < string.length() && Character.toUpperCase(string.charAt(n2)) != c) {
                    ++n2;
                }
                if (n2 >= string.length()) {
                    return false;
                }
                int n3 = n - 1;
                ++n2;
                while (string2.length() > n && string.length() > n2) {
                    c = Character.toUpperCase(string2.charAt(n++));
                    if (Character.toUpperCase(string.charAt(n2)) != c) {
                        if (c == '%' || c == '_') {
                            --n;
                            break;
                        }
                        n = n3;
                        continue block4;
                    }
                    ++n2;
                }
                bl = false;
                continue;
            }
            if (Character.toUpperCase(string.charAt(n2)) != c) {
                return false;
            }
            ++n2;
        }
        while (string2.length() > n) {
            if (Character.toUpperCase(string2.charAt(n++)) == '%') continue;
            return false;
        }
        return string.length() <= n2 || bl;
    }

    static int long2int(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    static long double2long(double d) {
        if (d > 9.223372036854776E18) {
            return Long.MAX_VALUE;
        }
        if (d < -9.223372036854776E18) {
            return Long.MIN_VALUE;
        }
        return (long)d;
    }

    static float bytes2float(byte[] byArray) {
        return Float.intBitsToFloat(Utils.bytes2int(byArray));
    }

    static double bytes2double(byte[] byArray) {
        return Double.longBitsToDouble(Utils.bytes2long(byArray));
    }

    static long bytes2long(byte[] byArray) {
        long l = 0L;
        int n = Math.min(8, byArray.length);
        for (int i = 0; i < n; ++i) {
            l = l << 8 | (long)(byArray[i] & 0xFF);
        }
        return l;
    }

    static int bytes2int(byte[] byArray) {
        int n = 0;
        int n2 = Math.min(4, byArray.length);
        for (int i = 0; i < n2; ++i) {
            n = n << 8 | byArray[i] & 0xFF;
        }
        return n;
    }

    static byte[] double2bytes(double d) {
        return Utils.long2bytes(Double.doubleToLongBits(d));
    }

    static byte[] float2bytes(float f) {
        return Utils.int2bytes(Float.floatToIntBits(f));
    }

    static byte[] long2bytes(long l) {
        byte[] byArray = new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        return byArray;
    }

    static byte[] int2bytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    static String bytes2hex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length << 1);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(digits[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(digits[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    static byte[] hex2bytes(char[] cArray, int n, int n2) throws SQLException {
        try {
            byte[] byArray = new byte[n2 / 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(Utils.hexDigit2int(cArray[n++]) << 4 | Utils.hexDigit2int(cArray[n++]));
            }
            return byArray;
        }
        catch (Exception exception) {
            throw Utils.createSQLException("Invalid hex sequence at " + n);
        }
    }

    private static int hexDigit2int(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if ((c = (char)(c | 0x20)) >= 'a' && c <= 'f') {
            return c - 87;
        }
        throw new RuntimeException();
    }

    static byte[] unique2bytes(String string) throws SQLException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[16];
        byArray[3] = Utils.hex2byte(cArray, 0);
        byArray[2] = Utils.hex2byte(cArray, 2);
        byArray[1] = Utils.hex2byte(cArray, 4);
        byArray[0] = Utils.hex2byte(cArray, 6);
        byArray[5] = Utils.hex2byte(cArray, 9);
        byArray[4] = Utils.hex2byte(cArray, 11);
        byArray[7] = Utils.hex2byte(cArray, 14);
        byArray[6] = Utils.hex2byte(cArray, 16);
        byArray[8] = Utils.hex2byte(cArray, 19);
        byArray[9] = Utils.hex2byte(cArray, 21);
        byArray[10] = Utils.hex2byte(cArray, 24);
        byArray[11] = Utils.hex2byte(cArray, 26);
        byArray[12] = Utils.hex2byte(cArray, 28);
        byArray[13] = Utils.hex2byte(cArray, 30);
        byArray[14] = Utils.hex2byte(cArray, 32);
        byArray[15] = Utils.hex2byte(cArray, 34);
        return byArray;
    }

    private static byte hex2byte(char[] cArray, int n) throws SQLException {
        try {
            return (byte)(Utils.hexDigit2int(cArray[n++]) << 4 | Utils.hexDigit2int(cArray[n++]));
        }
        catch (Exception exception) {
            throw Utils.createSQLException("Invalid hex sequence at position " + n + " in '" + new String(cArray) + '\'');
        }
    }

    static String bytes2unique(byte[] byArray, int n) {
        Object[] objectArray;
        if (byArray.length - n < 16) {
            objectArray = new byte[16];
            System.arraycopy(byArray, n, objectArray, 0, byArray.length - n);
            byArray = objectArray;
        }
        objectArray = new char[36];
        objectArray[23] = 45;
        objectArray[18] = 45;
        objectArray[13] = 45;
        objectArray[8] = 45;
        objectArray[0] = digits[byArray[n + 3] >> 4 & 0xF];
        objectArray[1] = digits[byArray[n + 3] & 0xF];
        objectArray[2] = digits[byArray[n + 2] >> 4 & 0xF];
        objectArray[3] = digits[byArray[n + 2] & 0xF];
        objectArray[4] = digits[byArray[n + 1] >> 4 & 0xF];
        objectArray[5] = digits[byArray[n + 1] & 0xF];
        objectArray[6] = digits[byArray[n + 0] >> 4 & 0xF];
        objectArray[7] = digits[byArray[n + 0] & 0xF];
        objectArray[9] = digits[byArray[n + 5] >> 4 & 0xF];
        objectArray[10] = digits[byArray[n + 5] & 0xF];
        objectArray[11] = digits[byArray[n + 4] >> 4 & 0xF];
        objectArray[12] = digits[byArray[n + 4] & 0xF];
        objectArray[14] = digits[byArray[n + 7] >> 4 & 0xF];
        objectArray[15] = digits[byArray[n + 7] & 0xF];
        objectArray[16] = digits[byArray[n + 6] >> 4 & 0xF];
        objectArray[17] = digits[byArray[n + 6] & 0xF];
        objectArray[19] = digits[byArray[n + 8] >> 4 & 0xF];
        objectArray[20] = digits[byArray[n + 8] & 0xF];
        objectArray[21] = digits[byArray[n + 9] >> 4 & 0xF];
        objectArray[22] = digits[byArray[n + 9] & 0xF];
        objectArray[24] = digits[byArray[n + 10] >> 4 & 0xF];
        objectArray[25] = digits[byArray[n + 10] & 0xF];
        objectArray[26] = digits[byArray[n + 11] >> 4 & 0xF];
        objectArray[27] = digits[byArray[n + 11] & 0xF];
        objectArray[28] = digits[byArray[n + 12] >> 4 & 0xF];
        objectArray[29] = digits[byArray[n + 12] & 0xF];
        objectArray[30] = digits[byArray[n + 13] >> 4 & 0xF];
        objectArray[31] = digits[byArray[n + 13] & 0xF];
        objectArray[32] = digits[byArray[n + 14] >> 4 & 0xF];
        objectArray[33] = digits[byArray[n + 14] & 0xF];
        objectArray[34] = digits[byArray[n + 15] >> 4 & 0xF];
        objectArray[35] = digits[byArray[n + 15] & 0xF];
        return new String((char[])objectArray);
    }

    static boolean string2boolean(String string) {
        try {
            return Double.parseDouble(string) != 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            return "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "t".equalsIgnoreCase(string);
        }
    }

    static long doubleToMoney(double d) {
        if (d < 0.0) {
            return (long)(d * 10000.0 - 0.5);
        }
        return (long)(d * 10000.0 + 0.5);
    }

    static int indexOf(char c, char[] cArray, int n, int n2) {
        c = (char)(c | 0x20);
        int n3 = n + n2;
        while (n < n3) {
            if ((cArray[n] | 0x20) == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static int indexOf(int n, int[] nArray) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    static int indexOf(byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray.length;
        int n3 = byArray2.length - n2;
        while (n <= n3) {
            block3: {
                for (int i = 0; i < n2; ++i) {
                    if (byArray2[n + i] == byArray[i]) {
                        continue;
                    }
                    break block3;
                }
                return n;
            }
            ++n;
        }
        return -1;
    }

    static int compareBytes(byte[] byArray, byte[] byArray2) {
        int n = Math.min(byArray.length, byArray2.length);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            n2 = byArray[i] < byArray2[i] ? -1 : 1;
            break;
        }
        if (n2 == 0 && byArray.length != byArray2.length) {
            n2 = byArray.length < byArray2.length ? -1 : 1;
        }
        return n2;
    }

    static CommandSelect createMemoryCommandSelect(SSConnection sSConnection, String[] stringArray, Object[][] objectArray) throws SQLException {
        MemoryResult memoryResult = new MemoryResult(objectArray, stringArray.length);
        CommandSelect commandSelect = new CommandSelect(sSConnection.log);
        for (int i = 0; i < stringArray.length; ++i) {
            ExpressionName expressionName = new ExpressionName(stringArray[i]);
            commandSelect.addColumnExpression(expressionName);
            expressionName.setFrom((DataSource)memoryResult, i, memoryResult.getColumn(i));
        }
        commandSelect.setSource(memoryResult);
        return commandSelect;
    }

    static final Integer getInteger(int n) {
        if (n >= -4 && n < 256) {
            return integerCache[n + 4];
        }
        return new Integer(n);
    }

    static final Short getShort(int n) {
        if (n >= -4 && n < 256) {
            return shortCache[n + 4];
        }
        return new Short((short)n);
    }

    static {
        for (int i = -4; i < 256; ++i) {
            Utils.integerCache[i + 4] = new Integer(i);
            Utils.shortCache[i + 4] = new Short((short)i);
        }
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

