/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.File;
import java.io.RandomAccessFile;
import java.sql.DriverManager;
import java.sql.SQLException;
import smallsql.database.Column;
import smallsql.database.Columns;
import smallsql.database.Database;
import smallsql.database.SSConnection;
import smallsql.database.Table;
import smallsql.database.Utils;
import smallsql.database.View;

abstract class TableView {
    static final int MAGIC_TABLE = 1397836884;
    static final int MAGIC_VIEW = 1397836886;
    static final int TABLE_VIEW_VERSION = 2;
    static final int TABLE_VIEW_OLD_VERSION = 1;
    final String name;
    final Columns columns;
    private long timestamp = System.currentTimeMillis();
    static final int LOCK_NONE = 0;
    static final int LOCK_INSERT = 1;
    static final int LOCK_READ = 2;
    static final int LOCK_WRITE = 3;
    static final int LOCK_TAB = 4;

    TableView(String string, Columns columns) {
        this.name = string;
        this.columns = columns;
    }

    static TableView load(SSConnection sSConnection, Database database, String string) throws SQLException {
        RandomAccessFile randomAccessFile = null;
        try {
            String string2 = Utils.createTableViewFileName(database, string);
            File file = new File(string2);
            if (!file.exists()) {
                throw Utils.createSQLException("Table or View '" + string + "' does not exist");
            }
            randomAccessFile = new RandomAccessFile(file, "rw");
            int n = randomAccessFile.readInt();
            int n2 = randomAccessFile.readInt();
            switch (n) {
                case 1397836884: 
                case 1397836886: {
                    break;
                }
                default: {
                    throw Utils.createSQLException("File '" + string2 + "' is not a valid Table or View store.");
                }
            }
            if (n2 > 2) {
                throw Utils.createSQLException("File version (" + n2 + ") of file '" + string2 + "' is to new for this runtume.");
            }
            if (n2 < 1) {
                throw Utils.createSQLException("File version (" + n2 + ") of file '" + string2 + "' is to old for this runtume.");
            }
            if (n == 1397836884) {
                return new Table(database, sSConnection, string, randomAccessFile, randomAccessFile.getFilePointer(), n2);
            }
            return new View(sSConnection, string, randomAccessFile, randomAccessFile.getFilePointer());
        }
        catch (Throwable throwable) {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    DriverManager.println(exception.toString());
                }
            }
            throw Utils.createSQLException(throwable);
        }
    }

    File getFile(Database database) throws Exception {
        return new File(Utils.createTableViewFileName(database, this.name));
    }

    RandomAccessFile createFile(Database database) throws Exception {
        File file = this.getFile(database);
        boolean bl = file.createNewFile();
        if (!bl) {
            throw Utils.createSQLException("Table or View '" + this.name + "' already exists.");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        this.writeMagic(randomAccessFile);
        return randomAccessFile;
    }

    abstract void writeMagic(RandomAccessFile var1) throws Exception;

    String getName() {
        return this.name;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    final int findColumnIdx(String string) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    final Column findColumn(String string) {
        for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            if (!column.getName().equalsIgnoreCase(string)) continue;
            return column;
        }
        return null;
    }

    void close() throws Exception {
    }
}

