/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import smallsql.database.Command;
import smallsql.database.SQLParser;
import smallsql.database.SSConnection;
import smallsql.database.SSResultSet;
import smallsql.database.Utils;

class SSStatement
implements Statement {
    final SSConnection con;
    Command cmd;
    int rsType;
    int rsConcurrency;
    private int fetchDirection;
    private int fetchSize;
    private int queryTimeout;
    private int maxRows;
    private int maxFieldSize;
    private ArrayList batches;
    private boolean needGeneratedKeys;
    private ResultSet generatedKeys;
    private int[] generatedKeyIndexes;
    private String[] generatedKeyNames;

    SSStatement(SSConnection sSConnection) throws SQLException {
        this(sSConnection, 1003, 1007);
    }

    SSStatement(SSConnection sSConnection, int n, int n2) throws SQLException {
        this.con = sSConnection;
        this.rsType = n;
        this.rsConcurrency = n2;
        sSConnection.testClosedConnection();
    }

    public final ResultSet executeQuery(String string) throws SQLException {
        this.executeImpl(string);
        return this.cmd.getQueryResult();
    }

    public final int executeUpdate(String string) throws SQLException {
        this.executeImpl(string);
        return this.cmd.getUpdateCount();
    }

    public final boolean execute(String string) throws SQLException {
        this.executeImpl(string);
        return this.cmd.getResultSet() != null;
    }

    private final void executeImpl(String string) throws SQLException {
        this.generatedKeys = null;
        try {
            this.con.log.println(string);
            SQLParser sQLParser = new SQLParser();
            this.cmd = sQLParser.parse(this.con, string);
            if (this.maxRows != 0 && (this.cmd.getMaxRows() == -1 || this.cmd.getMaxRows() > this.maxRows)) {
                this.cmd.setMaxRows(this.maxRows);
            }
            this.cmd.execute(this.con, this);
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
        this.needGeneratedKeys = false;
        this.generatedKeyIndexes = null;
        this.generatedKeyNames = null;
    }

    public final void close() throws SQLException {
        this.con.log.println("Statement.close");
        this.cmd = null;
    }

    public final int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public final void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public final int getMaxRows() {
        return this.maxRows;
    }

    public final void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw Utils.createSQLException("Wrong max rows value:" + n);
        }
        this.maxRows = n;
    }

    public final void setEscapeProcessing(boolean bl) throws SQLException {
    }

    public final int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public final void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    public final void cancel() {
    }

    public final SQLWarning getWarnings() {
        return null;
    }

    public final void clearWarnings() {
    }

    public final void setCursorName(String string) throws SQLException {
        throw Utils.createUnsupportedException("setCursorName");
    }

    public final ResultSet getResultSet() {
        return this.cmd.getResultSet();
    }

    public final int getUpdateCount() throws SQLException {
        return this.cmd.getUpdateCount();
    }

    public final boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public final void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public final int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public final void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public final int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public final int getResultSetConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    public final int getResultSetType() throws SQLException {
        return this.rsType;
    }

    public final void addBatch(String string) {
        if (this.batches == null) {
            this.batches = new ArrayList();
        }
        this.batches.add(string);
    }

    public void clearBatch() {
        if (this.batches == null) {
            return;
        }
        this.batches.clear();
    }

    public int[] executeBatch() throws BatchUpdateException {
        if (this.batches == null) {
            return new int[0];
        }
        int[] nArray = new int[this.batches.size()];
        SQLException sQLException = null;
        for (int i = 0; i < nArray.length; ++i) {
            try {
                nArray[i] = this.executeUpdate((String)this.batches.get(i));
                continue;
            }
            catch (SQLException sQLException2) {
                nArray[i] = -3;
                if (sQLException == null) {
                    sQLException = new BatchUpdateException(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode(), nArray);
                    sQLException.initCause(sQLException2);
                }
                sQLException.setNextException(sQLException2);
            }
        }
        this.batches.clear();
        if (sQLException != null) {
            throw sQLException;
        }
        return nArray;
    }

    public final Connection getConnection() {
        return this.con;
    }

    public final boolean getMoreResults(int n) throws SQLException {
        switch (n) {
            case 1: 
            case 3: {
                SSResultSet sSResultSet = this.cmd.getResultSet();
                this.cmd.rs = null;
                if (sSResultSet == null) break;
                sSResultSet.close();
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw Utils.createSQLException("Invalid flag value in method getMoreResults:" + n);
            }
        }
        return this.cmd.getMoreResults();
    }

    final void setNeedGeneratedKeys(int n) throws SQLException {
        switch (n) {
            case 2: {
                break;
            }
            case 1: {
                this.needGeneratedKeys = true;
                break;
            }
            default: {
                throw Utils.createSQLException("Invalid argument:" + n);
            }
        }
    }

    final void setNeedGeneratedKeys(int[] nArray) throws SQLException {
        this.needGeneratedKeys = nArray != null;
        this.generatedKeyIndexes = nArray;
    }

    final void setNeedGeneratedKeys(String[] stringArray) throws SQLException {
        this.needGeneratedKeys = stringArray != null;
        this.generatedKeyNames = stringArray;
    }

    final boolean needGeneratedKeys() {
        return this.needGeneratedKeys;
    }

    final int[] getGeneratedKeyIndexes() {
        return this.generatedKeyIndexes;
    }

    final String[] getGeneratedKeyNames() {
        return this.generatedKeyNames;
    }

    final void setGeneratedKeys(ResultSet resultSet) {
        this.generatedKeys = resultSet;
    }

    public final ResultSet getGeneratedKeys() throws SQLException {
        if (this.generatedKeys == null) {
            throw Utils.createSQLException("GeneratedKeys not requested");
        }
        return this.generatedKeys;
    }

    public final int executeUpdate(String string, int n) throws SQLException {
        this.setNeedGeneratedKeys(n);
        return this.executeUpdate(string);
    }

    public final int executeUpdate(String string, int[] nArray) throws SQLException {
        this.setNeedGeneratedKeys(nArray);
        return this.executeUpdate(string);
    }

    public final int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.setNeedGeneratedKeys(stringArray);
        return this.executeUpdate(string);
    }

    public final boolean execute(String string, int n) throws SQLException {
        this.setNeedGeneratedKeys(n);
        return this.execute(string);
    }

    public final boolean execute(String string, int[] nArray) throws SQLException {
        this.setNeedGeneratedKeys(nArray);
        return this.execute(string);
    }

    public final boolean execute(String string, String[] stringArray) throws SQLException {
        this.setNeedGeneratedKeys(stringArray);
        return this.execute(string);
    }

    public final int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException("Method getResultSetHoldability() not yet implemented.");
    }
}

