/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import smallsql.database.CommandSelect;
import smallsql.database.DateTime;
import smallsql.database.Expression;
import smallsql.database.ExpressionValue;
import smallsql.database.MutableNumeric;
import smallsql.database.SSResultSetMetaData;
import smallsql.database.SSStatement;
import smallsql.database.Utils;

public class SSResultSet
implements ResultSet {
    SSResultSetMetaData metaData = new SSResultSetMetaData();
    private CommandSelect cmd;
    private boolean wasNull;
    SSStatement st;
    private boolean isUpdatable;
    private boolean isInsertRow;
    private ExpressionValue[] values;
    private int fetchDirection;
    private int fetchSize;

    SSResultSet(SSStatement sSStatement, CommandSelect commandSelect) {
        this.st = sSStatement;
        this.metaData.columns = commandSelect.columnExpressions;
        this.cmd = commandSelect;
        this.isUpdatable = sSStatement != null && sSStatement.rsConcurrency == 1008 && !commandSelect.isGroupResult();
    }

    public void close() {
        this.st.con.log.println("ResultSet.close");
        this.cmd = null;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getString(int n) throws SQLException {
        try {
            String string = this.getValue(n).getString();
            this.wasNull = string == null;
            return string;
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            return expression.getBoolean();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getInt(n);
    }

    public int getInt(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            return expression.getInt();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public long getLong(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            return expression.getLong();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public float getFloat(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            return expression.getFloat();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            return expression.getDouble();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            MutableNumeric mutableNumeric = this.getValue(n).getNumeric();
            boolean bl = this.wasNull = mutableNumeric == null;
            if (this.wasNull) {
                return null;
            }
            return mutableNumeric.toBigDecimal(n2);
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            byte[] byArray = this.getValue(n).getBytes();
            this.wasNull = byArray == null;
            return byArray;
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            if (this.wasNull) {
                return null;
            }
            return DateTime.getDate(expression.getLong());
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            if (this.wasNull) {
                return null;
            }
            return DateTime.getTime(expression.getLong());
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            if (this.wasNull) {
                return null;
            }
            return DateTime.getTimestamp(expression.getLong());
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        throw Utils.createUnsupportedException("getAsciiStream");
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw Utils.createUnsupportedException("getUnicodeStream");
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        throw Utils.createUnsupportedException("getBinaryStream");
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public String getCursorName() {
        return null;
    }

    public ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    public Object getObject(int n) throws SQLException {
        try {
            Object object = this.getValue(n).getApiObject();
            this.wasNull = object == null;
            return object;
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        return this.getCmd().findColumn(string) + 1;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw Utils.createUnsupportedException("getCharacterStream");
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            MutableNumeric mutableNumeric = this.getValue(n).getNumeric();
            boolean bl = this.wasNull = mutableNumeric == null;
            if (this.wasNull) {
                return null;
            }
            return mutableNumeric.toBigDecimal();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.getCmd().isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        try {
            return this.getCmd().isAfterLast();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public boolean isFirst() throws SQLException {
        return this.getCmd().isFirst();
    }

    public boolean isLast() throws SQLException {
        try {
            return this.getCmd().isLast();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public void beforeFirst() throws SQLException {
        try {
            this.moveToCurrentRow();
            this.getCmd().beforeFirst();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public boolean first() throws SQLException {
        try {
            if (this.st.rsType == 1003) {
                throw Utils.createSQLException("ResultSet is forward only.");
            }
            this.moveToCurrentRow();
            return this.getCmd().first();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public boolean previous() throws SQLException {
        try {
            this.moveToCurrentRow();
            return this.getCmd().previous();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public boolean next() throws SQLException {
        try {
            this.moveToCurrentRow();
            return this.getCmd().next();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public boolean last() throws SQLException {
        try {
            this.moveToCurrentRow();
            return this.getCmd().last();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public void afterLast() throws SQLException {
        try {
            if (this.st.rsType == 1003) {
                throw Utils.createSQLException("ResultSet is forward only.");
            }
            this.moveToCurrentRow();
            this.getCmd().afterLast();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public boolean absolute(int n) throws SQLException {
        try {
            this.moveToCurrentRow();
            return this.getCmd().absolute(n);
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public boolean relative(int n) throws SQLException {
        try {
            this.moveToCurrentRow();
            return this.getCmd().relative(n);
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public int getRow() throws SQLException {
        try {
            return this.getCmd().getRow();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public void setFetchDirection(int n) {
        this.fetchDirection = n;
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        return this.getCmd().join.isScrollable() ? 1005 : 1003;
    }

    public int getConcurrency() {
        return this.isUpdatable ? 1008 : 1007;
    }

    public boolean rowUpdated() {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return this.getCmd().join.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this.getCmd().join.rowDeleted();
    }

    public void updateNull(int n) throws SQLException {
        this.updateValue(n, null, 504);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateValue(n, bl ? Boolean.TRUE : Boolean.FALSE, 301);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateValue(n, Utils.getShort(by), 321);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateValue(n, Utils.getShort(s), 322);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateValue(n, Utils.getInteger(n2), 323);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateValue(n, new Long(l), 325);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateValue(n, new Float(f), 336);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateValue(n, new Double(d), 338);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateValue(n, bigDecimal, 332);
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateValue(n, string, 353);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateValue(n, byArray, 311);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateValue(n, DateTime.valueOf(date), 340);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateValue(n, DateTime.valueOf(time), 341);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateValue(n, DateTime.valueOf(timestamp), 342);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateValue(n, inputStream, 359, n2);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateValue(n, inputStream, 313, n2);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw Utils.createUnsupportedException("Reader object");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateValue(n, object, -1);
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.updateValue(n, object, -1);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        this.st.con.log.println("insertRow()");
        this.getCmd().insertRow(this.st.con, this.values);
        this.cancelRowUpdates();
    }

    public void updateRow() throws SQLException {
        try {
            if (this.values == null) {
                return;
            }
            this.st.con.log.println("updateRow()");
            CommandSelect commandSelect = this.getCmd();
            commandSelect.updateRow(this.st.con, this.values);
            commandSelect.relative(0);
            this.cancelRowUpdates();
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public void deleteRow() throws SQLException {
        this.st.con.log.println("deleteRow()");
        this.getCmd().deleteRow(this.st.con);
        this.cancelRowUpdates();
    }

    public void refreshRow() throws SQLException {
        this.relative(0);
    }

    public void cancelRowUpdates() {
        if (this.values != null) {
            for (int i = this.values.length - 1; i >= 0; --i) {
                this.values[i].clear();
            }
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (!this.isUpdatable) {
            throw Utils.createSQLException("ResultSet is read only.");
        }
        this.isInsertRow = true;
    }

    public void moveToCurrentRow() {
        this.isInsertRow = false;
        this.cancelRowUpdates();
    }

    public Statement getStatement() {
        return this.st;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Ref getRef(int n) throws SQLException {
        throw Utils.createUnsupportedException("Ref object");
    }

    public Blob getBlob(int n) throws SQLException {
        throw Utils.createUnsupportedException("Blob object");
    }

    public Clob getClob(int n) throws SQLException {
        throw Utils.createUnsupportedException("Clob object");
    }

    public Array getArray(int n) throws SQLException {
        throw Utils.createUnsupportedException("Array");
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(string);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            if (calendar == null) {
                return this.getDate(n);
            }
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            if (this.wasNull) {
                return null;
            }
            return new Date(DateTime.addDateTimeOffset(expression.getLong(), calendar.getTimeZone()));
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            if (calendar == null) {
                return this.getTime(n);
            }
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            if (this.wasNull) {
                return null;
            }
            return new Time(DateTime.addDateTimeOffset(expression.getLong(), calendar.getTimeZone()));
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            if (calendar == null) {
                return this.getTimestamp(n);
            }
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            if (this.wasNull) {
                return null;
            }
            return new Timestamp(DateTime.addDateTimeOffset(expression.getLong(), calendar.getTimeZone()));
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public URL getURL(int n) throws SQLException {
        try {
            Expression expression = this.getValue(n);
            this.wasNull = expression.isNull();
            if (this.wasNull) {
                return null;
            }
            return new URL(expression.getString());
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw Utils.createUnsupportedException("Ref");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw Utils.createUnsupportedException("Blob");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw Utils.createUnsupportedException("Clob");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw Utils.createUnsupportedException("Array");
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    private final Expression getValue(int n) throws SQLException {
        ExpressionValue expressionValue;
        if (this.values != null && !(expressionValue = this.values[this.metaData.getColumnIdx(n)]).isEmpty()) {
            return expressionValue;
        }
        return this.metaData.getColumnExpression(n);
    }

    private final ExpressionValue getUpdateValue(int n) throws SQLException {
        if (this.values == null) {
            int n2 = this.metaData.getColumnCount();
            this.values = new ExpressionValue[n2];
            while (n2-- > 0) {
                this.values[n2] = new ExpressionValue();
            }
        }
        return this.values[this.metaData.getColumnIdx(n)];
    }

    private final void updateValue(int n, Object object, int n2) throws SQLException {
        this.getUpdateValue(n).set(object, n2);
        if (this.st.con.log.isLogging()) {
            this.st.con.log.println("parameter '" + this.metaData.getColumnName(n) + "' = " + object + "; type=" + n2);
        }
    }

    private final void updateValue(int n, Object object, int n2, int n3) throws SQLException {
        this.getUpdateValue(n).set(object, n2, n3);
        if (this.st.con.log.isLogging()) {
            this.st.con.log.println("parameter '" + this.metaData.getColumnName(n) + "' = " + object + "; type=" + n2 + "; length=" + n3);
        }
    }

    private final CommandSelect getCmd() throws SQLException {
        if (this.cmd == null) {
            throw Utils.createSQLException("ResultSet is closed.");
        }
        this.st.con.testClosedConnection();
        return this.cmd;
    }
}

