/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import smallsql.database.CommandSelect;
import smallsql.database.DateTime;
import smallsql.database.ExpressionValue;
import smallsql.database.Expressions;
import smallsql.database.SQLParser;
import smallsql.database.SSConnection;
import smallsql.database.SSResultSetMetaData;
import smallsql.database.SSStatement;
import smallsql.database.Utils;

class SSPreparedStatement
extends SSStatement
implements PreparedStatement {
    private final String sql;
    private ArrayList batches;
    private final int top;

    SSPreparedStatement(SSConnection sSConnection, String string) throws SQLException {
        this(sSConnection, string, 1003, 1007);
    }

    SSPreparedStatement(SSConnection sSConnection, String string, int n, int n2) throws SQLException {
        super(sSConnection, n, n2);
        this.sql = string;
        sSConnection.log.println(string);
        SQLParser sQLParser = new SQLParser();
        this.cmd = sQLParser.parse(sSConnection, string);
        this.top = this.cmd.getMaxRows();
    }

    public ResultSet executeQuery() throws SQLException {
        this.executeImp();
        return this.cmd.getQueryResult();
    }

    public int executeUpdate() throws SQLException {
        this.executeImp();
        return this.cmd.getUpdateCount();
    }

    private final void executeImp() throws SQLException {
        this.cmd.verifyParams();
        if (this.getMaxRows() != 0 && (this.top == -1 || this.top > this.getMaxRows())) {
            this.cmd.setMaxRows(this.getMaxRows());
        }
        this.cmd.execute(this.con, this);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.cmd.setParamValue(n, null, 504);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.cmd.setParamValue(n, bl ? Boolean.TRUE : Boolean.FALSE, 301);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.cmd.setParamValue(n, new Integer(by), 321);
    }

    public void setShort(int n, short s) throws SQLException {
        this.cmd.setParamValue(n, new Integer(s), 322);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.cmd.setParamValue(n, new Integer(n2), 323);
    }

    public void setLong(int n, long l) throws SQLException {
        this.cmd.setParamValue(n, new Long(l), 325);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.cmd.setParamValue(n, new Float(f), 336);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.cmd.setParamValue(n, new Double(d), 338);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.cmd.setParamValue(n, bigDecimal, 332);
    }

    public void setString(int n, String string) throws SQLException {
        this.cmd.setParamValue(n, string, 353);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.cmd.setParamValue(n, byArray, 310);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.cmd.setParamValue(n, DateTime.valueOf(date), 340);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.cmd.setParamValue(n, DateTime.valueOf(time), 341);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.cmd.setParamValue(n, DateTime.valueOf(timestamp), 342);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.cmd.setParamValue(n, inputStream, 359, n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException("Method setUnicodeStream() not yet implemented.");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.cmd.setParamValue(n, inputStream, 313, n2);
    }

    public void clearParameters() throws SQLException {
        this.cmd.clearParams();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.cmd.setParamValue(n, object, -1);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.cmd.setParamValue(n, object, -1);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.cmd.setParamValue(n, object, -1);
    }

    public boolean execute() throws SQLException {
        this.executeImp();
        return this.cmd.getResultSet() != null;
    }

    public void addBatch() throws SQLException {
        try {
            Expressions expressions = this.cmd.params;
            int n = expressions.size();
            ExpressionValue[] expressionValueArray = new ExpressionValue[n];
            for (int i = 0; i < n; ++i) {
                expressionValueArray[i] = (ExpressionValue)expressions.get(i).clone();
            }
            if (this.batches == null) {
                this.batches = new ArrayList();
            }
            this.batches.add(expressionValueArray);
        }
        catch (Exception exception) {
            throw Utils.createSQLException(exception);
        }
    }

    public void clearBatch() {
        if (this.batches != null) {
            this.batches.clear();
        }
    }

    public int[] executeBatch() throws BatchUpdateException {
        if (this.batches == null || this.batches.size() == 0) {
            return new int[0];
        }
        int[] nArray = new int[this.batches.size()];
        SQLException sQLException = null;
        for (int i = 0; i < this.batches.size(); ++i) {
            try {
                ExpressionValue[] expressionValueArray = (ExpressionValue[])this.batches.get(i);
                for (int j = 0; j < expressionValueArray.length; ++j) {
                    ((ExpressionValue)this.cmd.params.get(j)).set(expressionValueArray[j]);
                }
                nArray[i] = this.executeUpdate();
                continue;
            }
            catch (SQLException sQLException2) {
                nArray[i] = -3;
                if (sQLException == null) {
                    sQLException = new BatchUpdateException(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode(), nArray);
                    sQLException.initCause(sQLException2);
                }
                sQLException.setNextException(sQLException2);
            }
        }
        this.batches.clear();
        if (sQLException != null) {
            throw sQLException;
        }
        return nArray;
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new UnsupportedOperationException("Method setCharacterStream() not yet implemented.");
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new UnsupportedOperationException("Method setRef() not yet implemented.");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw new UnsupportedOperationException("Method setBlob() not yet implemented.");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new UnsupportedOperationException("Method setClob() not yet implemented.");
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new UnsupportedOperationException("Method setArray() not yet implemented.");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.cmd instanceof CommandSelect) {
            try {
                ((CommandSelect)this.cmd).compile(this.con);
                SSResultSetMetaData sSResultSetMetaData = new SSResultSetMetaData();
                sSResultSetMetaData.columns = this.cmd.columnExpressions;
                return sSResultSetMetaData;
            }
            catch (Exception exception) {
                Utils.createSQLException(exception);
            }
        }
        return null;
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException("Method setDate() not yet implemented.");
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException("Method setTime() not yet implemented.");
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException("Method setTimestamp() not yet implemented.");
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        throw new UnsupportedOperationException("Method setNull() not yet implemented.");
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw new UnsupportedOperationException("Method setURL() not yet implemented.");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException("Method getParameterMetaData() not yet implemented.");
    }
}

