/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.RandomAccessFile;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import smallsql.database.Database;
import smallsql.database.Logger;
import smallsql.database.SSCallableStatement;
import smallsql.database.SSDatabaseMetaData;
import smallsql.database.SSPreparedStatement;
import smallsql.database.SSSavepoint;
import smallsql.database.SSStatement;
import smallsql.database.StorePage;
import smallsql.database.Utils;

public class SSConnection
implements Connection {
    private Database database;
    private boolean autoCommit = true;
    int isolationLevel = 2;
    private List commitPages = new ArrayList();
    private long transactionTime;
    private final SSDatabaseMetaData metadata;
    private int holdability;
    final Logger log;

    SSConnection(Properties properties) throws SQLException {
        this.log = new Logger();
        String string = properties.getProperty("dbpath");
        boolean bl = "true".equals(properties.getProperty("create"));
        this.database = Database.getDatabase(string, this, bl);
        this.metadata = new SSDatabaseMetaData(this);
    }

    SSConnection(SSConnection sSConnection) {
        this.database = sSConnection.database;
        this.metadata = sSConnection.metadata;
        this.log = sSConnection.log;
    }

    Database getDatabase(boolean bl) throws SQLException {
        this.testClosedConnection();
        if (!bl && this.database == null) {
            throw Utils.createSQLException("You are not connected with a Database.");
        }
        return this.database;
    }

    public Statement createStatement() throws SQLException {
        return new SSStatement(this);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return new SSPreparedStatement(this, string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return new SSCallableStatement(this, string);
    }

    public String nativeSQL(String string) {
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.log.isLogging()) {
            this.log.println("AutoCommit:" + bl);
        }
        if (this.autoCommit != bl) {
            this.commit();
            this.autoCommit = bl;
        }
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    void add(StorePage storePage) throws SQLException {
        this.testClosedConnection();
        this.commitPages.add(storePage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        try {
            this.log.println("Commit");
            this.testClosedConnection();
            List list = this.commitPages;
            synchronized (list) {
                StorePage storePage;
                int n;
                int n2 = this.commitPages.size();
                for (n = 0; n < n2; ++n) {
                    storePage = (StorePage)this.commitPages.get(n);
                    storePage.commit();
                }
                for (n = 0; n < n2; ++n) {
                    storePage = (StorePage)this.commitPages.get(n);
                    storePage.freeLock();
                }
                this.commitPages.clear();
                this.transactionTime = System.currentTimeMillis();
            }
        }
        catch (Throwable throwable) {
            this.rollback();
            throw Utils.createSQLException(throwable);
        }
    }

    void rollbackFile(RandomAccessFile randomAccessFile) throws SQLException {
        this.testClosedConnection();
        for (int i = this.commitPages.size() - 1; i >= 0; --i) {
            StorePage storePage = (StorePage)this.commitPages.get(i);
            if (storePage.raFile != randomAccessFile) continue;
            storePage.rollback();
            storePage.freeLock();
        }
    }

    void rollback(int n) throws SQLException {
        this.testClosedConnection();
        for (int i = this.commitPages.size() - 1; i >= n; --i) {
            StorePage storePage = (StorePage)this.commitPages.remove(i);
            storePage.rollback();
            storePage.freeLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        this.log.println("Rollback");
        this.testClosedConnection();
        List list = this.commitPages;
        synchronized (list) {
            int n = this.commitPages.size();
            for (int i = 0; i < n; ++i) {
                StorePage storePage = (StorePage)this.commitPages.get(i);
                storePage.rollback();
                storePage.freeLock();
            }
            this.commitPages.clear();
            this.transactionTime = System.currentTimeMillis();
        }
    }

    public void close() throws SQLException {
        this.rollback();
        this.database = null;
        this.commitPages = null;
        Database.closeConnection(this);
    }

    final void testClosedConnection() throws SQLException {
        if (this.isClosed()) {
            throw Utils.createSQLException("Connection is already closed.");
        }
    }

    public boolean isClosed() {
        return this.commitPages == null;
    }

    public DatabaseMetaData getMetaData() {
        return this.metadata;
    }

    public void setReadOnly(boolean bl) {
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setCatalog(String string) throws SQLException {
        this.testClosedConnection();
        this.database = Database.getDatabase(string, this, false);
    }

    public String getCatalog() {
        if (this.database == null) {
            return "";
        }
        return this.database.getName();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (!this.metadata.supportsTransactionIsolationLevel(n)) {
            throw Utils.createSQLException("Unknown Transaction Isolation Level:" + n);
        }
        this.isolationLevel = n;
    }

    public int getTransactionIsolation() {
        return this.isolationLevel;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return new SSStatement(this, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return new SSPreparedStatement(this, string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return new SSCallableStatement(this, string, n, n2);
    }

    public Map getTypeMap() {
        return null;
    }

    public void setTypeMap(Map map) {
    }

    public void setHoldability(int n) {
        this.holdability = n;
    }

    public int getHoldability() {
        return this.holdability;
    }

    int getSavepoint() throws SQLException {
        this.testClosedConnection();
        return this.commitPages.size();
    }

    public Savepoint setSavepoint() throws SQLException {
        return new SSSavepoint(this.getSavepoint(), null, this.transactionTime);
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        return new SSSavepoint(this.getSavepoint(), string, this.transactionTime);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (savepoint instanceof SSSavepoint) {
            if (((SSSavepoint)savepoint).transactionTime != this.transactionTime) {
                throw Utils.createSQLException("Savepoint is not valid for this transaction.");
            }
            this.rollback(savepoint.getSavepointId());
            return;
        }
        throw Utils.createSQLException("Savepoint is not valid for this driver." + savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (savepoint instanceof SSSavepoint) {
            ((SSSavepoint)savepoint).transactionTime = 0L;
            return;
        }
        throw Utils.createSQLException("Savepoint is not valid for this driver." + savepoint);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return new SSStatement(this, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return new SSPreparedStatement(this, string);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return new SSCallableStatement(this, string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        SSPreparedStatement sSPreparedStatement = new SSPreparedStatement(this, string);
        sSPreparedStatement.setNeedGeneratedKeys(n);
        return sSPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        SSPreparedStatement sSPreparedStatement = new SSPreparedStatement(this, string);
        sSPreparedStatement.setNeedGeneratedKeys(nArray);
        return sSPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        SSPreparedStatement sSPreparedStatement = new SSPreparedStatement(this, string);
        sSPreparedStatement.setNeedGeneratedKeys(stringArray);
        return sSPreparedStatement;
    }
}

