/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.IOException;
import java.io.RandomAccessFile;

class MemoryStream {
    private byte[] puffer = new byte[256];
    private int offset;

    MemoryStream() {
    }

    void writeTo(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.write(this.puffer, 0, this.offset);
    }

    void writeByte(int n) {
        this.verifyFreePufferSize(1);
        this.puffer[this.offset++] = (byte)n;
    }

    void writeShort(int n) {
        this.verifyFreePufferSize(2);
        this.puffer[this.offset++] = (byte)(n >> 8);
        this.puffer[this.offset++] = (byte)n;
    }

    void writeInt(int n) {
        this.verifyFreePufferSize(4);
        this.puffer[this.offset++] = (byte)(n >> 24);
        this.puffer[this.offset++] = (byte)(n >> 16);
        this.puffer[this.offset++] = (byte)(n >> 8);
        this.puffer[this.offset++] = (byte)n;
    }

    void writeLong(long l) {
        this.verifyFreePufferSize(8);
        this.puffer[this.offset++] = (byte)(l >> 56);
        this.puffer[this.offset++] = (byte)(l >> 48);
        this.puffer[this.offset++] = (byte)(l >> 40);
        this.puffer[this.offset++] = (byte)(l >> 32);
        this.puffer[this.offset++] = (byte)(l >> 24);
        this.puffer[this.offset++] = (byte)(l >> 16);
        this.puffer[this.offset++] = (byte)(l >> 8);
        this.puffer[this.offset++] = (byte)l;
    }

    void writeChars(char[] cArray) {
        this.verifyFreePufferSize(2 * cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            this.puffer[this.offset++] = (byte)(c >> 8);
            this.puffer[this.offset++] = (byte)c;
        }
    }

    void writeBytes(byte[] byArray, int n, int n2) {
        this.verifyFreePufferSize(n2);
        System.arraycopy(byArray, n, this.puffer, this.offset, n2);
        this.offset += n2;
    }

    private void verifyFreePufferSize(int n) {
        int n2 = this.offset + n;
        if (n2 < this.puffer.length) {
            int n3 = this.puffer.length << 1;
            if (n3 < n2) {
                n3 = n2;
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.puffer, 0, byArray, 0, this.offset);
            this.puffer = byArray;
        }
    }

    void skip(int n) {
        this.offset += n;
    }

    int readByte() {
        return this.puffer[this.offset++];
    }

    int readShort() {
        return (this.puffer[this.offset++] & 0xFF) << 8 | this.puffer[this.offset++] & 0xFF;
    }

    int readInt() {
        return (this.puffer[this.offset++] & 0xFF) << 24 | (this.puffer[this.offset++] & 0xFF) << 16 | (this.puffer[this.offset++] & 0xFF) << 8 | this.puffer[this.offset++] & 0xFF;
    }

    long readLong() {
        return (long)(this.puffer[this.offset++] & 0xFF) << 56 | (long)(this.puffer[this.offset++] & 0xFF) << 48 | (long)(this.puffer[this.offset++] & 0xFF) << 40 | (long)(this.puffer[this.offset++] & 0xFF) << 32 | (long)((this.puffer[this.offset++] & 0xFF) << 24) | (long)((this.puffer[this.offset++] & 0xFF) << 16) | (long)((this.puffer[this.offset++] & 0xFF) << 8) | (long)(this.puffer[this.offset++] & 0xFF);
    }

    char[] readChars(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.readShort();
        }
        return cArray;
    }

    byte[] readBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.puffer, this.offset, byArray, 0, n);
        this.offset += n;
        return byArray;
    }
}

