/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import smallsql.database.LongTreeList;
import smallsql.database.StoreImpl;
import smallsql.database.Utils;

class IndexNode {
    private final boolean unique;
    private final char digit;
    private static final IndexNode[] EMPTY_NODES = new IndexNode[0];
    private IndexNode[] nodes = EMPTY_NODES;
    private char[] remainderKey;
    private Object value;

    protected IndexNode(boolean bl, char c) {
        this.unique = bl;
        this.digit = c;
    }

    protected IndexNode createIndexNode(boolean bl, char c) {
        return new IndexNode(bl, c);
    }

    final char getDigit() {
        return this.digit;
    }

    final boolean getUnique() {
        return this.unique;
    }

    final boolean isEmpty() {
        return this.nodes == EMPTY_NODES && this.value == null;
    }

    final void clear() {
        this.nodes = EMPTY_NODES;
        this.value = null;
        this.remainderKey = null;
    }

    final void clearValue() {
        this.value = null;
    }

    final Object getValue() {
        return this.value;
    }

    final IndexNode[] getChildNodes() {
        return this.nodes;
    }

    final IndexNode getChildNode(char c) {
        int n = this.findNodePos(c);
        if (n >= 0) {
            return this.nodes[n];
        }
        return null;
    }

    final char[] getRemainderValue() {
        return this.remainderKey;
    }

    final IndexNode addNode(char c) throws SQLException {
        int n;
        if (this.remainderKey != null) {
            this.moveRemainderValue();
        }
        if ((n = this.findNodePos(c)) == -1) {
            IndexNode indexNode = this.createIndexNode(this.unique, c);
            this.saveNode(indexNode);
            return indexNode;
        }
        return this.nodes[n];
    }

    final void removeNode(char c) {
        int n = this.findNodePos(c);
        if (n != -1) {
            int n2 = this.nodes.length - 1;
            IndexNode[] indexNodeArray = new IndexNode[n2];
            System.arraycopy(this.nodes, 0, indexNodeArray, 0, n);
            System.arraycopy(this.nodes, n + 1, indexNodeArray, n, n2 - n);
            this.nodes = indexNodeArray;
        }
    }

    final void addNode(char c, long l) throws SQLException {
        IndexNode indexNode = this.addNode(c);
        if (indexNode.remainderKey != null) {
            indexNode.moveRemainderValue();
        }
        indexNode.saveValue(l);
    }

    final void saveValue(long l) throws SQLException {
        if (this.unique) {
            if (this.value != null) {
                throw Utils.createSQLException("Duplikate Key");
            }
            this.value = new Long(l);
        } else {
            LongTreeList longTreeList = (LongTreeList)this.value;
            if (longTreeList == null) {
                longTreeList = new LongTreeList();
                this.value = longTreeList;
            }
            longTreeList.add(l);
        }
    }

    final void addRemainderKey(long l, long l2, int n) throws SQLException {
        this.saveRemainderValue(l2, n);
        this.value = this.unique ? new Long(l) : new LongTreeList(l);
    }

    final void addRemainderKey(long l, char[] cArray, int n) throws SQLException {
        this.saveRemainderValue(cArray, n);
        this.value = this.unique ? new Long(l) : new LongTreeList(l);
    }

    final IndexNode addRoot(char c) throws SQLException {
        IndexNode indexNode = this.addNode(c);
        if (indexNode.remainderKey != null) {
            indexNode.moveRemainderValue();
        }
        return indexNode.addRoot();
    }

    final IndexNode addRootValue(char[] cArray, int n) throws SQLException {
        this.saveRemainderValue(cArray, n);
        return this.addRoot();
    }

    final IndexNode addRootValue(long l, int n) throws SQLException {
        this.saveRemainderValue(l, n);
        return this.addRoot();
    }

    private final void moveRemainderValue() throws SQLException {
        Object object = this.value;
        char[] cArray = this.remainderKey;
        this.value = null;
        this.remainderKey = null;
        IndexNode indexNode = this.addNode(cArray[0]);
        if (cArray.length == 1) {
            indexNode.value = object;
        } else {
            indexNode.moveRemainderValueSub(object, cArray);
        }
    }

    private final void moveRemainderValueSub(Object object, char[] cArray) {
        int n = cArray.length - 1;
        this.remainderKey = new char[n];
        this.value = object;
        System.arraycopy(cArray, 1, this.remainderKey, 0, n);
    }

    private final void saveRemainderValue(char[] cArray, int n) {
        int n2 = cArray.length - n;
        this.remainderKey = new char[n2];
        System.arraycopy(cArray, n, this.remainderKey, 0, n2);
    }

    private final void saveRemainderValue(long l, int n) {
        this.remainderKey = new char[n];
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            this.remainderKey[n2++] = (char)(l >> (i << 4));
        }
    }

    final IndexNode addRoot() throws SQLException {
        IndexNode indexNode = (IndexNode)this.value;
        if (indexNode == null) {
            indexNode = this.createIndexNode(this.unique, '\uffff');
            this.value = indexNode;
        }
        return indexNode;
    }

    private final void saveNode(IndexNode indexNode) {
        int n = this.nodes.length;
        IndexNode[] indexNodeArray = new IndexNode[n + 1];
        if (n == 0) {
            indexNodeArray[0] = indexNode;
        } else {
            int n2 = this.findNodeInsertPos(indexNode.digit, 0, n);
            System.arraycopy(this.nodes, 0, indexNodeArray, 0, n2);
            System.arraycopy(this.nodes, n2, indexNodeArray, n2 + 1, n - n2);
            indexNodeArray[n2] = indexNode;
        }
        this.nodes = indexNodeArray;
    }

    private final int findNodeInsertPos(char c, int n, int n2) {
        if (n == n2) {
            return n;
        }
        int n3 = n + (n2 - n) / 2;
        char c2 = this.nodes[n3].digit;
        if (c2 == c) {
            return n3;
        }
        if (c2 < c) {
            return this.findNodeInsertPos(c, n3 + 1, n2);
        }
        if (n == n3) {
            return n;
        }
        return this.findNodeInsertPos(c, n, n3);
    }

    private final int findNodePos(char c) {
        return this.findNodePos(c, 0, this.nodes.length);
    }

    private final int findNodePos(char c, int n, int n2) {
        if (n == this.nodes.length) {
            return -1;
        }
        int n3 = n + (n2 - n) / 2;
        char c2 = this.nodes[n3].digit;
        if (c2 == c) {
            return n3;
        }
        if (c2 < c) {
            return this.findNodePos(c, n3 + 1, n2);
        }
        if (n == n3) {
            return -1;
        }
        return this.findNodePos(c, n, n3 - 1);
    }

    void save(StoreImpl storeImpl) throws SQLException {
        storeImpl.writeShort(this.digit);
        int n = this.remainderKey == null ? 0 : this.remainderKey.length;
        storeImpl.writeInt(n);
        if (n > 0) {
            storeImpl.writeChars(this.remainderKey);
        }
        if (this.value == null) {
            storeImpl.writeByte(0);
        } else if (this.value instanceof Long) {
            storeImpl.writeByte(1);
            storeImpl.writeLong((Long)this.value);
        } else if (this.value instanceof LongTreeList) {
            storeImpl.writeByte(2);
            ((LongTreeList)this.value).save(storeImpl);
        } else if (this.value instanceof IndexNode) {
            storeImpl.writeByte(3);
            ((IndexNode)this.value).saveRef(storeImpl);
        }
        storeImpl.writeShort(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].saveRef(storeImpl);
        }
    }

    void saveRef(StoreImpl storeImpl) throws SQLException {
    }

    IndexNode loadRef(long l) throws SQLException {
        throw new Error();
    }

    void load(StoreImpl storeImpl) throws SQLException {
        int n = storeImpl.readInt();
        this.remainderKey = n > 0 ? storeImpl.readChars(n) : null;
        int n2 = storeImpl.readByte();
        switch (n2) {
            case 0: {
                this.value = null;
                break;
            }
            case 1: {
                this.value = new Long(storeImpl.readLong());
                break;
            }
            case 2: {
                this.value = new LongTreeList(storeImpl);
                break;
            }
            case 3: {
                this.value = this.loadRef(storeImpl.readLong());
                break;
            }
            default: {
                throw Utils.createSQLException("Error in loading Index. Index fils is corrupt. (" + n2 + ")");
            }
        }
        this.nodes = new IndexNode[storeImpl.readShort()];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = this.loadRef(storeImpl.readLong());
        }
    }
}

