/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import java.util.ArrayList;
import smallsql.database.Expression;
import smallsql.database.Expressions;
import smallsql.database.IndexNode;
import smallsql.database.IndexScrollStatus;
import smallsql.database.LongTreeList;
import smallsql.database.MutableNumeric;

class Index {
    final IndexNode rootPage;

    Index(boolean bl) {
        this.rootPage = new IndexNode(bl, '\uffff');
    }

    Index(IndexNode indexNode) {
        this.rootPage = indexNode;
    }

    IndexScrollStatus createScrollStatus(Expressions expressions) {
        return new IndexScrollStatus(this.rootPage, expressions);
    }

    final Object findRows(Expressions expressions, ArrayList arrayList) throws Exception {
        IndexNode indexNode = this.rootPage;
        int n = expressions.size();
        for (int i = 0; i < n; ++i) {
            if ((indexNode = this.findRows(indexNode, expressions.get(i), arrayList)) == null) {
                return null;
            }
            if (i + 1 == n) {
                return indexNode.getValue();
            }
            indexNode = (IndexNode)indexNode.getValue();
        }
        throw new Error();
    }

    final Object findRows(Expression[] expressionArray, ArrayList arrayList) throws Exception {
        IndexNode indexNode = this.rootPage;
        int n = expressionArray.length;
        for (int i = 0; i < n; ++i) {
            if ((indexNode = this.findRows(indexNode, expressionArray[i], arrayList)) == null) {
                return null;
            }
            if (i + 1 == n) {
                return indexNode.getValue();
            }
            indexNode = (IndexNode)indexNode.getValue();
        }
        throw new Error();
    }

    private final IndexNode findRows(IndexNode indexNode, Expression expression, ArrayList arrayList) throws Exception {
        if (expression.isNull()) {
            indexNode = this.findNull(indexNode);
        } else {
            switch (expression.getDataType()) {
                case 336: {
                    indexNode = this.find(indexNode, Index.floatToBinarySortOrder(expression.getFloat()), 2, arrayList);
                    break;
                }
                case 337: 
                case 338: {
                    indexNode = this.find(indexNode, Index.doubleToBinarySortOrder(expression.getDouble()), 4, arrayList);
                    break;
                }
                case 321: {
                    indexNode = this.find(indexNode, expression.getInt(), 1, arrayList);
                    break;
                }
                case 322: {
                    indexNode = this.find(indexNode, Index.shortToBinarySortOrder(expression.getInt()), 1, arrayList);
                    break;
                }
                case 323: {
                    indexNode = this.find(indexNode, Index.intToBinarySortOrder(expression.getInt()), 2, arrayList);
                    break;
                }
                case 325: 
                case 330: 
                case 331: 
                case 340: 
                case 341: 
                case 342: 
                case 343: {
                    indexNode = this.find(indexNode, Index.longToBinarySortOrder(expression.getLong()), 4, arrayList);
                    break;
                }
                case 353: 
                case 355: 
                case 359: 
                case 360: 
                case 362: {
                    indexNode = this.find(indexNode, Index.stringToBinarySortOrder(expression.getString(), false), arrayList);
                    break;
                }
                case 350: 
                case 352: {
                    indexNode = this.find(indexNode, Index.stringToBinarySortOrder(expression.getString(), true), arrayList);
                    break;
                }
                case 310: 
                case 311: 
                case 313: 
                case 316: 
                case 370: {
                    indexNode = this.find(indexNode, Index.bytesToBinarySortOrder(expression.getBytes()), arrayList);
                    break;
                }
                case 300: 
                case 301: {
                    indexNode = this.find(indexNode, expression.getBoolean() ? 2L : 1L, 1, arrayList);
                    break;
                }
                case 332: 
                case 333: {
                    indexNode = this.find(indexNode, Index.numericToBinarySortOrder(expression.getNumeric()), arrayList);
                    break;
                }
                default: {
                    throw new Error(String.valueOf(expression.getDataType()));
                }
            }
        }
        return indexNode;
    }

    final void addValues(long l, Expressions expressions) throws Exception {
        IndexNode indexNode = this.rootPage;
        int n = expressions.size();
        block13: for (int i = 0; i < n; ++i) {
            boolean bl;
            Expression expression = expressions.get(i);
            boolean bl2 = bl = i == n - 1;
            if (expression.isNull()) {
                indexNode = this.addNull(indexNode, l, bl);
                continue;
            }
            switch (expression.getDataType()) {
                case 336: {
                    indexNode = this.add(indexNode, l, Index.floatToBinarySortOrder(expression.getFloat()), bl, 2);
                    continue block13;
                }
                case 337: 
                case 338: {
                    indexNode = this.add(indexNode, l, Index.doubleToBinarySortOrder(expression.getDouble()), bl, 4);
                    continue block13;
                }
                case 321: {
                    indexNode = this.add(indexNode, l, expression.getInt(), bl, 1);
                    continue block13;
                }
                case 322: {
                    indexNode = this.add(indexNode, l, Index.shortToBinarySortOrder(expression.getInt()), bl, 1);
                    continue block13;
                }
                case 323: {
                    indexNode = this.add(indexNode, l, Index.intToBinarySortOrder(expression.getInt()), bl, 2);
                    continue block13;
                }
                case 325: 
                case 330: 
                case 331: 
                case 340: 
                case 341: 
                case 342: 
                case 343: {
                    indexNode = this.add(indexNode, l, Index.longToBinarySortOrder(expression.getLong()), bl, 4);
                    continue block13;
                }
                case 353: 
                case 355: 
                case 359: 
                case 360: {
                    indexNode = this.add(indexNode, l, Index.stringToBinarySortOrder(expression.getString(), false), bl);
                    continue block13;
                }
                case 350: 
                case 352: {
                    indexNode = this.add(indexNode, l, Index.stringToBinarySortOrder(expression.getString(), true), bl);
                    continue block13;
                }
                case 310: 
                case 311: 
                case 313: 
                case 316: 
                case 370: {
                    indexNode = this.add(indexNode, l, Index.bytesToBinarySortOrder(expression.getBytes()), bl);
                    continue block13;
                }
                case 300: 
                case 301: {
                    indexNode = this.add(indexNode, l, expression.getBoolean() ? 2L : 1L, bl, 1);
                    continue block13;
                }
                case 332: 
                case 333: {
                    indexNode = this.add(indexNode, l, Index.numericToBinarySortOrder(expression.getNumeric()), bl);
                    continue block13;
                }
                default: {
                    throw new Error(String.valueOf(expression.getDataType()));
                }
            }
        }
    }

    final void removeValue(long l, Expressions expressions) throws Exception {
        Object object;
        ArrayList arrayList = new ArrayList();
        Object object2 = this.findRows(expressions, arrayList);
        if (!this.rootPage.getUnique()) {
            object = (LongTreeList)object2;
            ((LongTreeList)object).remove(l);
            if (((LongTreeList)object).getSize() > 0) {
                return;
            }
        }
        object = (IndexNode)arrayList.get(arrayList.size() - 1);
        ((IndexNode)object).clearValue();
        for (int i = arrayList.size() - 2; i >= 0 && ((IndexNode)object).isEmpty(); --i) {
            IndexNode indexNode = (IndexNode)arrayList.get(i);
            indexNode.removeNode(((IndexNode)object).getDigit());
            object = indexNode;
        }
    }

    private final IndexNode findNull(IndexNode indexNode) {
        return indexNode.getChildNode('\u0000');
    }

    private final IndexNode addNull(IndexNode indexNode, long l, boolean bl) throws SQLException {
        if (bl) {
            indexNode.addNode('\u0000', l);
            return null;
        }
        return indexNode.addRoot('\u0000');
    }

    private final IndexNode find(IndexNode indexNode, long l, int n, ArrayList arrayList) {
        for (int i = n - 1; i >= 0; --i) {
            char c = (char)(l >> (i << 4));
            if ((indexNode = indexNode.getChildNode(c)) == null) {
                return null;
            }
            if (arrayList != null) {
                arrayList.add(indexNode);
            }
            if (!this.equals(indexNode.getRemainderValue(), l, i)) continue;
            return indexNode;
        }
        return indexNode;
    }

    private final IndexNode add(IndexNode indexNode, long l, long l2, boolean bl, int n) throws SQLException {
        for (int i = n - 1; i >= 0; --i) {
            char c = (char)(l2 >> (i << 4));
            if (i == 0) {
                if (bl) {
                    indexNode.addNode(c, l);
                    return null;
                }
                return indexNode.addRoot(c);
            }
            if ((indexNode = indexNode.addNode(c)).isEmpty()) {
                if (bl) {
                    indexNode.addRemainderKey(l, l2, i);
                    return null;
                }
                return indexNode.addRootValue(l2, i);
            }
            if (!this.equals(indexNode.getRemainderValue(), l2, i)) continue;
            if (bl) {
                indexNode.saveValue(l);
                return null;
            }
            return indexNode.addRoot();
        }
        throw new Error();
    }

    private final IndexNode find(IndexNode indexNode, char[] cArray, ArrayList arrayList) {
        int n = cArray.length;
        int n2 = -1;
        do {
            char c = n2 < 0 ? (n == 0 ? (char)'\u0001' : '\u0002') : cArray[n2];
            indexNode = indexNode.getChildNode(c);
            if (indexNode == null) {
                return null;
            }
            if (arrayList != null) {
                arrayList.add(indexNode);
            }
            if (++n2 != n) continue;
            return indexNode;
        } while (!this.equals(indexNode.getRemainderValue(), cArray, n2));
        return indexNode;
    }

    private final IndexNode add(IndexNode indexNode, long l, char[] cArray, boolean bl) throws SQLException {
        int n = cArray.length;
        int n2 = -1;
        do {
            char c;
            char c2 = n2 < 0 ? (n == 0 ? (char)'\u0001' : '\u0002') : (c = cArray[n2]);
            if (++n2 == n) {
                if (bl) {
                    indexNode.addNode(c, l);
                    return null;
                }
                return indexNode.addRoot(c);
            }
            if (!(indexNode = indexNode.addNode(c)).isEmpty()) continue;
            if (bl) {
                indexNode.addRemainderKey(l, cArray, n2);
                return null;
            }
            return indexNode.addRootValue(cArray, n2);
        } while (!this.equals(indexNode.getRemainderValue(), cArray, n2));
        if (bl) {
            indexNode.saveValue(l);
            return null;
        }
        return indexNode.addRoot();
    }

    final void clear() {
        this.rootPage.clear();
    }

    private static final int floatToBinarySortOrder(float f) {
        int n = Float.floatToIntBits(f);
        return n < 0 ? ~n : n ^ Integer.MIN_VALUE;
    }

    private static final long doubleToBinarySortOrder(double d) {
        long l = Double.doubleToLongBits(d);
        return l < 0L ? l ^ 0xFFFFFFFFFFFFFFFFL : l ^ Long.MIN_VALUE;
    }

    private static final int shortToBinarySortOrder(int n) {
        return n ^ 0x8000;
    }

    private static final int intToBinarySortOrder(int n) {
        return n ^ Integer.MIN_VALUE;
    }

    private static final long longToBinarySortOrder(long l) {
        return l ^ Long.MIN_VALUE;
    }

    private static final char[] stringToBinarySortOrder(String string, boolean bl) {
        int n;
        if (bl) {
            for (n = string.length(); n > 0 && string.charAt(n - 1) == ' '; --n) {
            }
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = Character.toLowerCase(Character.toUpperCase(string.charAt(i)));
        }
        return cArray;
    }

    private static final char[] bytesToBinarySortOrder(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return cArray;
    }

    private static final char[] numericToBinarySortOrder(MutableNumeric mutableNumeric) {
        int n;
        int[] nArray = mutableNumeric.getInternalValue();
        int n2 = 1;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            n2 = 2 * (nArray.length - n) + 1;
            break;
        }
        char[] cArray = new char[n2];
        cArray[0] = (char)n2;
        int n3 = 1;
        while (n3 < n2) {
            cArray[n3++] = (char)(nArray[n] >> 16);
            cArray[n3++] = (char)nArray[n++];
        }
        return cArray;
    }

    private final boolean equals(char[] cArray, char[] cArray2, int n) {
        if (cArray == null) {
            return false;
        }
        int n2 = cArray.length;
        if (n2 != cArray2.length - n) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] == cArray2[i + n]) continue;
            return false;
        }
        return true;
    }

    private final boolean equals(char[] cArray, long l, int n) {
        if (cArray == null) {
            return false;
        }
        int n2 = cArray.length;
        if (n2 != n) {
            return false;
        }
        int n3 = n - 1;
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] == (char)(l >> (n3-- << 4))) continue;
            return false;
        }
        return true;
    }
}

