/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import smallsql.database.DateTime;
import smallsql.database.Expression;
import smallsql.database.Money;
import smallsql.database.MutableDouble;
import smallsql.database.MutableFloat;
import smallsql.database.MutableInteger;
import smallsql.database.MutableLong;
import smallsql.database.MutableNumeric;
import smallsql.database.SQLTokenizer;
import smallsql.database.Utils;

public class ExpressionValue
extends Expression {
    private Object value;
    private int dataType;
    private int length;
    private static final Object EMPTY = new Object();

    ExpressionValue() {
        super(1);
        this.clear();
    }

    ExpressionValue(int n) {
        super(n);
        switch (n) {
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                this.clear();
                break;
            }
            case 16: 
            case 17: {
                break;
            }
            case 12: {
                this.value = new MutableInteger(0);
                this.dataType = 323;
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    ExpressionValue(Object object, int n) {
        super(1);
        this.value = object;
        this.dataType = n;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof ExpressionValue)) {
            return false;
        }
        Object object2 = ((ExpressionValue)object).value;
        if (object2 == this.value) {
            return true;
        }
        if (this.value == null) {
            return false;
        }
        return this.value.equals(object2);
    }

    void accumulate(Expression expression) throws Exception {
        int n = this.getType();
        if (n != 11) {
            expression = expression.getParams()[0];
        }
        block0 : switch (n) {
            case 11: 
            case 14: {
                if (!this.isEmpty()) break;
                this.set(expression.getObject(), expression.getDataType());
                break;
            }
            case 15: {
                this.set(expression.getObject(), expression.getDataType());
                break;
            }
            case 12: {
                if (expression.isNull()) break;
                ++((MutableInteger)this.value).value;
                break;
            }
            case 13: {
                if (this.isEmpty()) {
                    this.initValue(expression);
                    break;
                }
                switch (this.dataType) {
                    case 321: 
                    case 322: 
                    case 323: {
                        ((MutableInteger)this.value).value += expression.getInt();
                        break block0;
                    }
                    case 325: {
                        ((MutableLong)this.value).value += expression.getLong();
                        break block0;
                    }
                    case 336: {
                        ((MutableFloat)this.value).value += expression.getFloat();
                        break block0;
                    }
                    case 337: 
                    case 338: {
                        ((MutableDouble)this.value).value += expression.getDouble();
                        break block0;
                    }
                    case 332: 
                    case 333: {
                        MutableNumeric mutableNumeric = expression.getNumeric();
                        if (mutableNumeric == null) break block0;
                        ((MutableNumeric)this.value).add(mutableNumeric);
                        break block0;
                    }
                    case 331: {
                        ((Money)this.value).value += expression.getMoney();
                        break block0;
                    }
                    default: {
                        throw Utils.createSQLException("Unsupported data type " + SQLTokenizer.getKeyWord(this.dataType) + " for SUM function.");
                    }
                }
            }
            case 17: {
                if (this.value == null) {
                    if (expression.isNull()) {
                        this.dataType = expression.getDataType();
                        break;
                    }
                    this.initValue(expression);
                    break;
                }
                if (expression.isNull()) break;
                switch (this.dataType) {
                    case 321: 
                    case 322: 
                    case 323: {
                        ((MutableInteger)this.value).value = Math.max(((MutableInteger)this.value).value, expression.getInt());
                        break block0;
                    }
                    case 325: {
                        ((MutableLong)this.value).value = Math.max(((MutableLong)this.value).value, expression.getLong());
                        break block0;
                    }
                    case 336: {
                        ((MutableFloat)this.value).value = Math.max(((MutableFloat)this.value).value, expression.getFloat());
                        break block0;
                    }
                    case 337: 
                    case 338: {
                        ((MutableDouble)this.value).value = Math.max(((MutableDouble)this.value).value, expression.getDouble());
                        break block0;
                    }
                    case 350: 
                    case 353: 
                    case 359: {
                        String string = expression.getString();
                        if (String.CASE_INSENSITIVE_ORDER.compare((String)this.value, string) >= 0) break block0;
                        this.value = string;
                        break block0;
                    }
                    case 332: 
                    case 333: {
                        MutableNumeric mutableNumeric = expression.getNumeric();
                        if (((MutableNumeric)this.value).compareTo(mutableNumeric) >= 0) break block0;
                        this.value = mutableNumeric;
                        break block0;
                    }
                    case 331: {
                        ((Money)this.value).value = Math.max(((Money)this.value).value, expression.getMoney());
                        break block0;
                    }
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: {
                        ((DateTime)this.value).time = Math.max(((DateTime)this.value).time, expression.getLong());
                        break block0;
                    }
                    default: {
                        throw new Error("" + this.dataType);
                    }
                }
            }
            case 16: {
                if (this.value == null) {
                    if (expression.isNull()) {
                        this.dataType = expression.getDataType();
                        break;
                    }
                    this.initValue(expression);
                    break;
                }
                if (expression.isNull()) break;
                switch (this.dataType) {
                    case 321: 
                    case 322: 
                    case 323: {
                        ((MutableInteger)this.value).value = Math.min(((MutableInteger)this.value).value, expression.getInt());
                        break block0;
                    }
                    case 325: {
                        ((MutableLong)this.value).value = Math.min(((MutableLong)this.value).value, expression.getLong());
                        break block0;
                    }
                    case 336: {
                        ((MutableFloat)this.value).value = Math.min(((MutableFloat)this.value).value, expression.getFloat());
                        break block0;
                    }
                    case 337: 
                    case 338: {
                        ((MutableDouble)this.value).value = Math.min(((MutableDouble)this.value).value, expression.getDouble());
                        break block0;
                    }
                    case 350: 
                    case 353: 
                    case 359: {
                        String string = expression.getString();
                        if (String.CASE_INSENSITIVE_ORDER.compare((String)this.value, string) <= 0) break block0;
                        this.value = string;
                        break block0;
                    }
                    case 332: 
                    case 333: {
                        MutableNumeric mutableNumeric = expression.getNumeric();
                        if (((MutableNumeric)this.value).compareTo(mutableNumeric) <= 0) break block0;
                        this.value = mutableNumeric;
                        break block0;
                    }
                    case 331: {
                        ((Money)this.value).value = Math.min(((Money)this.value).value, expression.getMoney());
                        break block0;
                    }
                    case 340: 
                    case 341: 
                    case 342: 
                    case 343: {
                        ((DateTime)this.value).time = Math.min(((DateTime)this.value).time, expression.getLong());
                        break block0;
                    }
                    default: {
                        throw new Error("" + this.dataType);
                    }
                }
            }
            default: {
                throw new Error();
            }
        }
    }

    private void initValue(Expression expression) throws Exception {
        this.dataType = expression.getDataType();
        switch (this.dataType) {
            case 321: 
            case 322: 
            case 323: {
                this.value = new MutableInteger(expression.getInt());
                break;
            }
            case 325: {
                this.value = new MutableLong(expression.getLong());
                break;
            }
            case 336: {
                this.value = new MutableFloat(expression.getFloat());
                break;
            }
            case 337: 
            case 338: {
                this.value = new MutableDouble(expression.getDouble());
                break;
            }
            case 330: 
            case 331: {
                this.value = Money.createFromUnscaledValue(expression.getMoney());
                break;
            }
            case 332: 
            case 333: {
                this.value = new MutableNumeric(expression.getNumeric());
                break;
            }
            case 340: 
            case 341: 
            case 342: 
            case 343: {
                this.value = new DateTime(expression.getLong(), this.dataType);
                break;
            }
            default: {
                this.value = expression.getObject();
            }
        }
    }

    final boolean isEmpty() {
        return this.value == EMPTY;
    }

    final void clear() {
        this.value = EMPTY;
    }

    final void set(Object object, int n, int n2) throws SQLException {
        this.set(object, n);
        this.length = n2;
    }

    final void set(Object object, int n) throws SQLException {
        this.value = object;
        this.dataType = n;
        if (this.dataType < 0) {
            if (object == null) {
                this.dataType = 504;
            } else if (object instanceof String) {
                this.dataType = 353;
            } else if (object instanceof Byte) {
                this.dataType = 321;
            } else if (object instanceof Short) {
                this.dataType = 322;
            } else if (object instanceof Integer) {
                this.dataType = 323;
            } else if (object instanceof Long) {
                this.dataType = 325;
            } else if (object instanceof Float) {
                this.dataType = 336;
            } else if (object instanceof Double) {
                this.dataType = 338;
            } else if (object instanceof Number) {
                this.dataType = 332;
            } else if (object instanceof Date) {
                DateTime dateTime = DateTime.valueOf((Date)object);
                this.value = dateTime;
                this.dataType = dateTime.getDataType();
            } else if (object instanceof byte[]) {
                this.dataType = 311;
            } else if (object instanceof Boolean) {
                this.dataType = 301;
            } else if (object instanceof Money) {
                this.dataType = 331;
            } else {
                throw Utils.createSQLException("Unknown parameter class:" + object.getClass().getName());
            }
        }
    }

    final void set(ExpressionValue expressionValue) {
        this.value = expressionValue.value;
        this.dataType = expressionValue.dataType;
        this.length = expressionValue.length;
    }

    boolean isNull() {
        return this.value == null;
    }

    boolean getBoolean() throws Exception {
        return ExpressionValue.getBoolean(this.value, this.dataType);
    }

    static boolean getBoolean(Object object, int n) throws Exception {
        if (object == null) {
            return false;
        }
        switch (n) {
            case 300: 
            case 301: {
                return object.equals(Boolean.TRUE);
            }
            case 321: 
            case 322: 
            case 323: 
            case 325: {
                return ((Number)object).intValue() != 0;
            }
            case 331: 
            case 336: 
            case 338: {
                return ((Number)object).doubleValue() != 0.0;
            }
        }
        return Utils.string2boolean(object.toString());
    }

    int getInt() throws Exception {
        return ExpressionValue.getInt(this.value, this.dataType);
    }

    static int getInt(Object object, int n) throws Exception {
        if (object == null) {
            return 0;
        }
        switch (n) {
            case 300: 
            case 301: {
                return object == Boolean.TRUE ? 1 : 0;
            }
            case 321: 
            case 322: 
            case 323: 
            case 325: 
            case 331: 
            case 336: 
            case 337: 
            case 338: {
                return ((Number)object).intValue();
            }
            case 340: 
            case 341: 
            case 342: 
            case 343: {
                return (int)((DateTime)object).getTimeMillis();
            }
        }
        String string = object.toString().trim();
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            return (int)Double.parseDouble(string);
        }
    }

    long getLong() throws Exception {
        return ExpressionValue.getLong(this.value, this.dataType);
    }

    static long getLong(Object object, int n) throws Exception {
        if (object == null) {
            return 0L;
        }
        switch (n) {
            case 300: 
            case 301: {
                return object == Boolean.TRUE ? 1L : 0L;
            }
            case 321: 
            case 322: 
            case 323: 
            case 325: 
            case 331: 
            case 338: {
                return ((Number)object).longValue();
            }
            case 340: 
            case 341: 
            case 342: 
            case 343: {
                return ((DateTime)object).getTimeMillis();
            }
        }
        String string = object.toString();
        if (string.indexOf(45) > 0 || string.indexOf(58) > 0) {
            return DateTime.parse(string);
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return (long)Double.parseDouble(string);
        }
    }

    float getFloat() throws Exception {
        return ExpressionValue.getFloat(this.value, this.dataType);
    }

    static float getFloat(Object object, int n) throws Exception {
        if (object == null) {
            return 0.0f;
        }
        switch (n) {
            case 300: {
                return object.equals(Boolean.TRUE) ? 1.0f : 0.0f;
            }
            case 323: 
            case 325: 
            case 331: 
            case 336: 
            case 337: 
            case 338: {
                return ((Number)object).floatValue();
            }
            case 340: 
            case 341: 
            case 342: 
            case 343: {
                return ((DateTime)object).getTimeMillis();
            }
        }
        return Float.parseFloat(object.toString());
    }

    double getDouble() throws Exception {
        return ExpressionValue.getDouble(this.value, this.dataType);
    }

    static double getDouble(Object object, int n) throws Exception {
        if (object == null) {
            return 0.0;
        }
        switch (n) {
            case 300: {
                return object.equals(Boolean.TRUE) ? 1.0 : 0.0;
            }
            case 323: 
            case 325: 
            case 331: 
            case 338: {
                return ((Number)object).doubleValue();
            }
            case 340: 
            case 341: 
            case 342: 
            case 343: {
                return ((DateTime)object).getTimeMillis();
            }
        }
        return Double.parseDouble(object.toString());
    }

    long getMoney() throws Exception {
        return ExpressionValue.getMoney(this.value, this.dataType);
    }

    static long getMoney(Object object, int n) throws Exception {
        if (object == null) {
            return 0L;
        }
        switch (n) {
            case 300: {
                return object == Boolean.TRUE ? 10000L : 0L;
            }
            case 321: 
            case 322: 
            case 323: 
            case 325: {
                return ((Number)object).longValue() * 10000L;
            }
            case 336: 
            case 337: 
            case 338: {
                return Utils.doubleToMoney(((Number)object).doubleValue());
            }
            case 330: 
            case 331: {
                return ((Money)object).value;
            }
        }
        return Money.parseMoney(object.toString());
    }

    MutableNumeric getNumeric() {
        return ExpressionValue.getNumeric(this.value, this.dataType);
    }

    static MutableNumeric getNumeric(Object object, int n) {
        if (object == null) {
            return null;
        }
        switch (n) {
            case 300: {
                return new MutableNumeric(object == Boolean.TRUE ? 1 : 0);
            }
            case 323: {
                return new MutableNumeric(((Number)object).intValue());
            }
            case 325: {
                return new MutableNumeric(((Number)object).longValue());
            }
            case 336: {
                float f = ((Number)object).floatValue();
                if (Float.isInfinite(f) || Float.isNaN(f)) {
                    return null;
                }
                return new MutableNumeric(f);
            }
            case 337: 
            case 338: {
                double d = ((Number)object).doubleValue();
                if (Double.isInfinite(d) || Double.isNaN(d)) {
                    return null;
                }
                return new MutableNumeric(d);
            }
            case 330: 
            case 331: {
                return new MutableNumeric(((Money)object).value, 4);
            }
            case 332: 
            case 333: {
                if (object instanceof MutableNumeric) {
                    return (MutableNumeric)object;
                }
                return new MutableNumeric((BigDecimal)object);
            }
        }
        return new MutableNumeric(object.toString());
    }

    Object getObject() {
        return this.value;
    }

    String getString() {
        if (this.value == null) {
            return null;
        }
        if (this.dataType == 300) {
            return this.value == Boolean.TRUE ? "1" : "0";
        }
        return this.value.toString();
    }

    byte[] getBytes() throws Exception {
        return ExpressionValue.getBytes(this.value, this.dataType);
    }

    static byte[] getBytes(Object object, int n) throws Exception {
        if (object == null) {
            return null;
        }
        switch (n) {
            case 310: 
            case 311: {
                return (byte[])object;
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: {
                return ((String)object).getBytes();
            }
            case 370: {
                return Utils.unique2bytes((String)object);
            }
            case 323: {
                return Utils.int2bytes(((Number)object).intValue());
            }
            case 338: {
                return Utils.double2bytes(((Number)object).doubleValue());
            }
            case 336: {
                return Utils.float2bytes(((Number)object).floatValue());
            }
        }
        throw ExpressionValue.createUnspportedConversion(n, object, 311);
    }

    final int getDataType() {
        return this.dataType;
    }

    String getTableName() {
        return null;
    }

    final int getPrecision() {
        switch (this.dataType) {
            case 350: 
            case 353: {
                return ((String)this.value).length();
            }
            case 310: 
            case 311: {
                return ((byte[])this.value).length;
            }
        }
        return super.getPrecision();
    }

    int getScale() {
        switch (this.dataType) {
            case 332: 
            case 333: {
                MutableNumeric mutableNumeric = this.getNumeric();
                return mutableNumeric == null ? 0 : mutableNumeric.getScale();
            }
        }
        return ExpressionValue.getScale(this.dataType);
    }

    static SQLException createUnspportedConversion(int n, Object object, int n2) {
        return Utils.createSQLException("Can't convert '" + SQLTokenizer.getKeyWord(n) + "' [" + object + ']' + "' to '" + SQLTokenizer.getKeyWord(n2) + '\'');
    }
}

