/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.Column;
import smallsql.database.DataSource;
import smallsql.database.Expression;
import smallsql.database.MutableNumeric;
import smallsql.database.TableView;

public class ExpressionName
extends Expression {
    private String tableAlias;
    private DataSource fromEntry;
    private int colIdx;
    private TableView table;
    private Column column;

    ExpressionName(String string) {
        super(2);
        this.setName(string);
    }

    ExpressionName(int n) {
        super(n);
    }

    void setNameAfterTableAlias(String string) {
        this.tableAlias = this.getName();
        this.setName(string);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof ExpressionName)) {
            return false;
        }
        return ((ExpressionName)object).fromEntry == this.fromEntry;
    }

    boolean isNull() throws Exception {
        return this.fromEntry.isNull(this.colIdx);
    }

    boolean getBoolean() throws Exception {
        return this.fromEntry.getBoolean(this.colIdx);
    }

    int getInt() throws Exception {
        return this.fromEntry.getInt(this.colIdx);
    }

    long getLong() throws Exception {
        return this.fromEntry.getLong(this.colIdx);
    }

    float getFloat() throws Exception {
        return this.fromEntry.getFloat(this.colIdx);
    }

    double getDouble() throws Exception {
        return this.fromEntry.getDouble(this.colIdx);
    }

    long getMoney() throws Exception {
        return this.fromEntry.getMoney(this.colIdx);
    }

    MutableNumeric getNumeric() throws Exception {
        return this.fromEntry.getNumeric(this.colIdx);
    }

    Object getObject() throws Exception {
        return this.fromEntry.getObject(this.colIdx);
    }

    String getString() throws Exception {
        return this.fromEntry.getString(this.colIdx);
    }

    byte[] getBytes() throws Exception {
        return this.fromEntry.getBytes(this.colIdx);
    }

    int getDataType() {
        switch (this.getType()) {
            case 2: 
            case 11: {
                return this.fromEntry.getDataType(this.colIdx);
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return this.getParams()[0].getDataType();
            }
            case 12: {
                return 323;
            }
        }
        throw new Error();
    }

    void setFrom(DataSource dataSource, int n, TableView tableView) {
        this.fromEntry = dataSource;
        this.colIdx = n;
        this.table = tableView;
        this.column = tableView.columns.get(n);
    }

    void setFrom(DataSource dataSource, int n, Column column) {
        this.fromEntry = dataSource;
        this.colIdx = n;
        this.column = column;
    }

    String getTableAlias() {
        return this.tableAlias;
    }

    final TableView getTable() {
        return this.table;
    }

    final int getColumnIndex() {
        return this.colIdx;
    }

    final Column getColumn() {
        return this.column;
    }

    public final String toString() {
        if (this.tableAlias == null) {
            return String.valueOf(this.getAlias());
        }
        return this.tableAlias + "." + this.getAlias();
    }

    String getTableName() {
        if (this.table != null) {
            return this.table.getName();
        }
        return null;
    }

    int getPrecision() {
        return this.column.getPrecision();
    }

    int getScale() {
        return this.column.getScale();
    }

    int getDisplaySize() {
        return this.column.getDisplaySize();
    }

    boolean isAutoIncrement() {
        return this.column.isAutoIncrement();
    }

    boolean isCaseSensitive() {
        return this.column.isCaseSensitive();
    }

    boolean isNullable() {
        return this.column.isNullable();
    }

    boolean isDefinitelyWritable() {
        return true;
    }
}

