/*
 * Decompiled with CFR 0.152.
 */
package nim;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import nim.NetworkMonitor;

public class Transceiver {
    private final Socket socket;
    private final NetworkMonitor monitor;
    private ObjectInputStream input = null;
    private ObjectOutputStream output = null;

    protected Transceiver(Socket socket, int n, NetworkMonitor networkMonitor) {
        this.socket = socket;
        this.monitor = networkMonitor;
        try {
            socket.setSoTimeout(n);
            this.output = new ObjectOutputStream(socket.getOutputStream());
            this.input = new ObjectInputStream(socket.getInputStream());
            this.trace("socket streams opened");
        }
        catch (IOException iOException) {
            this.processException(iOException, "failure opening socket streams");
        }
    }

    protected Transceiver(Socket socket, int n) {
        this(socket, n, null);
    }

    protected void send(Object object) {
        try {
            this.output.writeObject(object);
            this.output.flush();
            this.output.reset();
            this.trace(object, "sent");
        }
        catch (IOException iOException) {
            this.processException(iOException, "send failure");
        }
    }

    protected Object receive() {
        try {
            Object object = this.input.readObject();
            this.trace(object, "received");
            return object;
        }
        catch (IOException iOException) {
            this.processException(iOException, "receive failure");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.processException(classNotFoundException, "received unknown object");
        }
        return null;
    }

    protected void close() {
        try {
            this.socket.close();
            this.trace("socket closed");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void trace(String string) {
        if (this.monitor != null) {
            this.monitor.display(this.socket.getInetAddress() + ": " + string);
        }
    }

    private void trace(Object object, String string) {
        if (this.monitor != null) {
            this.monitor.display(string + ": " + object);
        }
    }

    private void processException(Exception exception, String string) {
        if (this.monitor != null) {
            this.monitor.display("exception caught: " + exception);
            this.monitor.display(this.socket.getInetAddress() + ": " + string);
        }
        this.close();
    }
}

