/*
 * Decompiled with CFR 0.152.
 */
package nim;

import java.net.Socket;
import java.util.Observable;
import nim.NetworkMonitor;
import nim.Nim;
import nim.NimInterface;
import nim.NimStrategy;
import nim.RemoteSetModel;
import nim.RemoteSuggest;
import nim.RemoteUpdate;
import nim.Transceiver;

public class RemoteNimUser
extends Transceiver
implements NimInterface {
    private static final int TIMEOUT = 1800000;
    private RemoteStrategy strategy = null;

    public RemoteNimUser(Socket socket, NetworkMonitor networkMonitor) {
        super(socket, 1800000, networkMonitor);
    }

    public RemoteNimUser(Socket socket) {
        this(socket, null);
    }

    public void setModel(Nim nim, boolean bl) {
        this.send(new RemoteSetModel(nim, bl));
        Object object = this.receive();
        nim.addObserver(this);
    }

    public NimStrategy userStrategy() {
        if (this.strategy == null) {
            this.strategy = new RemoteStrategy();
        }
        return this.strategy;
    }

    public void update(Observable observable, Object object) {
        this.send(new RemoteUpdate(observable, object));
    }

    private class RemoteStrategy
    implements NimStrategy {
        private RemoteStrategy() {
        }

        public Nim.Move suggest(Nim nim) {
            RemoteNimUser.this.send(new RemoteSuggest(nim));
            return (Nim.Move)RemoteNimUser.this.receive();
        }
    }
}

