/*
 * Decompiled with CFR 0.152.
 */
package nim;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import nim.NetworkMonitor;
import nim.NimView;
import nim.SettingsPanel;

public class NimStarter
extends JApplet {
    private static final int WIDTH = 500;
    private static final int HEIGHT = 680;
    private static final String HEADER = "N I M  Client/Server";
    public static final Color BG = Color.white;

    private static void setUp(Container container, boolean bl, ClassLoader classLoader, ImageLoader imageLoader, JFrame jFrame) {
        NimView nimView = new NimView(imageLoader);
        SettingsPanel settingsPanel = new SettingsPanel(nimView, bl);
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        NetworkMonitor networkMonitor = new NetworkMonitor(nimView, jTabbedPane, settingsPanel, bl, jFrame);
        jTabbedPane.addTab("game settings", null, settingsPanel, "Nim game settings");
        jTabbedPane.addTab("client/server", null, networkMonitor, "Client/Server monitor");
        container.setBackground(BG);
        container.setLayout(new BorderLayout());
        container.add("Center", nimView);
        container.add("South", jTabbedPane);
    }

    public void init() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        NimStarter.setUp(this.getContentPane(), true, classLoader, new AppletImageLoader(classLoader, this), null);
    }

    public static void main(String[] stringArray) {
        int n = 1;
        if (stringArray.length == 1) {
            try {
                n = Integer.parseInt(stringArray[0]);
                if (n < 1) {
                    n = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        for (int i = 0; i < n; ++i) {
            JFrame jFrame = new JFrame(HEADER);
            jFrame.setSize(500, 680);
            NimStarter.setUp(jFrame.getContentPane(), false, classLoader, new FrameImageLoader(classLoader, toolkit), jFrame);
            jFrame.setDefaultCloseOperation(3);
            jFrame.setVisible(true);
        }
    }

    private static class AppletImageLoader
    implements ImageLoader {
        private final ClassLoader loader;
        private final JApplet applet;

        public AppletImageLoader(ClassLoader classLoader, JApplet jApplet) {
            this.loader = classLoader;
            this.applet = jApplet;
        }

        public Image getImage(Component component, String string) {
            Image image = this.applet.getImage(this.loader.getResource(string));
            component.prepareImage(image, component);
            return image;
        }
    }

    private static class FrameImageLoader
    implements ImageLoader {
        private final ClassLoader loader;
        private final Toolkit toolkit;

        public FrameImageLoader(ClassLoader classLoader, Toolkit toolkit) {
            this.loader = classLoader;
            this.toolkit = toolkit;
        }

        public Image getImage(Component component, String string) {
            Image image = this.toolkit.getImage(this.loader.getResource(string));
            component.prepareImage(image, component);
            return image;
        }
    }

    public static interface ImageLoader {
        public Image getImage(Component var1, String var2);
    }
}

