/*
 * Decompiled with CFR 0.152.
 */
package nim;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import nim.NetworkMonitor;
import nim.RemoteNimUser;
import nim.SettingsPanel;

public class NimServer
extends ServerSocket {
    static final int PORT = 5321;
    private static final int TIMEOUT = 1800000;
    private final NetworkMonitor monitor;

    public NimServer(SettingsPanel settingsPanel, NetworkMonitor networkMonitor) throws IOException {
        super(5321);
        this.monitor = networkMonitor;
        this.setSoTimeout(1800000);
        this.trace("starting server at " + InetAddress.getLocalHost());
        settingsPanel.serverUp(this);
    }

    public NimServer() throws IOException {
        this(null, null);
    }

    public RemoteNimUser getNimUser() {
        this.trace("waiting for client connection...");
        try {
            Socket socket = this.accept();
            this.trace("connection accepted");
            RemoteNimUser remoteNimUser = new RemoteNimUser(socket, this.monitor);
            this.trace("remote user connected");
            return remoteNimUser;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.trace("server connection timeout");
            this.trace("no client connected");
        }
        catch (IOException iOException) {
            this.trace("exception caught: " + iOException);
            this.trace("server down");
        }
        return null;
    }

    private void trace(String string) {
        if (this.monitor != null) {
            this.monitor.display(string);
        }
    }
}

