/*
 * Decompiled with CFR 0.152.
 */
package nim;

import java.io.Serializable;
import nim.Discernible;

public class Nim
extends Discernible {
    private int[] available;
    private int total = 0;

    public Nim(int n, int n2, int n3) {
        if (n > 0 && n2 > 0 && n3 > 0) {
            this.available = new int[n];
            float f = n > 1 ? (float)(n3 - n2) / (float)(n - 1) : 0.0f;
            for (int i = 0; i < n; ++i) {
                this.available[i] = n2 + Math.round((float)i * f);
                this.total += this.available[i];
            }
        } else {
            this.available = new int[0];
        }
    }

    public Nim(int n) {
        this(n, n, 1);
    }

    public synchronized int rows() {
        return this.available.length;
    }

    public synchronized int available(int n) {
        if (n >= 0 && n < this.available.length) {
            return this.available[n];
        }
        return 0;
    }

    public synchronized int available() {
        return this.total;
    }

    public synchronized boolean over() {
        return this.total == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void take(int n, int n2) {
        Nim nim = this;
        synchronized (nim) {
            if (n2 > 0 && n2 <= this.available(n)) {
                this.available[n] = this.available[n] - n2;
                this.total -= n2;
            }
        }
        this.inform(null);
    }

    public void take(Move move) {
        this.take(move.row, move.amount);
    }

    public void nextMove(Move move) {
        this.inform(move);
    }

    public static class Move
    implements Serializable {
        public final int row;
        public final int amount;

        public Move(int n, int n2) {
            this.row = n;
            this.amount = n2;
        }
    }
}

