/*
 * Decompiled with CFR 0.152.
 */
package nim;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import nim.NimClient;
import nim.NimServer;
import nim.NimView;
import nim.SettingsPanel;

public class NetworkMonitor
extends JPanel {
    private static final int TXTW = 350;
    private static final int TXTH = 120;
    private static final String ADDRFILE = "server_ipaddr.txt";
    private final JTextArea messages = new JTextArea();
    private final JTextField serverAddress = new JTextField();
    private final JButton serverStarter = new ServerStarter();
    private final JButton clientStarter;
    private final SettingsPanel settings;
    private final boolean appletFlag;
    private final JFrame frame;
    private NimServer server = null;
    private NimClient client = null;

    public NetworkMonitor(NimView nimView, JTabbedPane jTabbedPane, SettingsPanel settingsPanel, boolean bl, JFrame jFrame) {
        Object object;
        this.settings = settingsPanel;
        this.appletFlag = bl;
        this.frame = jFrame;
        try {
            object = new BufferedReader(new FileReader(ADDRFILE));
            this.serverAddress.setText(((BufferedReader)object).readLine());
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clientStarter = new ClientStarter(jTabbedPane);
        this.client = new NimClient(nimView, this);
        this.messages.setEditable(false);
        if (bl) {
            this.serverStarter.setEnabled(false);
        }
        object = new JPanel();
        ((Container)object).setLayout(new GridLayout(4, 1));
        ((Container)object).add(new JLabel(" server:", 2));
        ((Container)object).add(this.serverAddress);
        ((Container)object).add(this.clientStarter);
        ((Container)object).add(this.serverStarter);
        this.setPreferredSize(new Dimension(350, 120));
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.messages));
        this.add("East", (Component)object);
    }

    public void display(String string) {
        this.messages.append(string + "\n");
    }

    private class ClientStarter
    extends JButton
    implements ActionListener {
        private final JTabbedPane tabbedPane;

        public ClientStarter(JTabbedPane jTabbedPane) {
            super("start client");
            this.tabbedPane = jTabbedPane;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = NetworkMonitor.this.serverAddress.getText();
            if (string.length() == 0) {
                string = "localhost";
                NetworkMonitor.this.serverAddress.setText("localhost");
            }
            NetworkMonitor.this.serverStarter.setEnabled(false);
            NetworkMonitor.this.clientStarter.setEnabled(false);
            NetworkMonitor.this.serverAddress.setEditable(false);
            this.tabbedPane.setEnabledAt(0, false);
            boolean bl = NetworkMonitor.this.client.startSession(string);
            if (bl) {
                if (!NetworkMonitor.this.appletFlag) {
                    NetworkMonitor.this.frame.setDefaultCloseOperation(0);
                }
            } else {
                NetworkMonitor.this.server = null;
                if (!NetworkMonitor.this.appletFlag) {
                    NetworkMonitor.this.serverStarter.setEnabled(true);
                }
                NetworkMonitor.this.clientStarter.setEnabled(true);
                NetworkMonitor.this.serverAddress.setEditable(true);
                this.tabbedPane.setEnabledAt(0, true);
            }
        }
    }

    private class ServerStarter
    extends JButton
    implements ActionListener {
        public ServerStarter() {
            super("start server");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NetworkMonitor.this.server = new NimServer(NetworkMonitor.this.settings, NetworkMonitor.this);
                NetworkMonitor.this.serverStarter.setEnabled(false);
                NetworkMonitor.this.clientStarter.setEnabled(false);
                NetworkMonitor.this.serverAddress.setEditable(false);
                NetworkMonitor.this.serverAddress.setText("localhost");
            }
            catch (IOException iOException) {
                NetworkMonitor.this.server = null;
                NetworkMonitor.this.display("exception caught: " + iOException);
                NetworkMonitor.this.display("server not running");
            }
        }
    }
}

