/*
 * Decompiled with CFR 0.152.
 */
package nim;

import java.util.Random;
import nim.ComputerStrategy;
import nim.Nim;

public class CleverStrategy
implements ComputerStrategy {
    private static final int ALLEVEN = -1;
    private final boolean reverseGame;
    private final Random random;

    public CleverStrategy(boolean bl) {
        this.reverseGame = bl;
        this.random = new Random();
    }

    public Nim.Move suggest(Nim nim) {
        int n;
        int n2;
        if (nim.over()) {
            return null;
        }
        int n3 = nim.rows();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n = nim.available(n2);
            if (n6 < n) {
                n6 = n;
            }
            if (n == 1) {
                ++n4;
                continue;
            }
            if (n <= 1) continue;
            ++n5;
            n7 = n2;
        }
        if (n5 == 0) {
            n2 = Math.abs(this.random.nextInt()) % n3;
            while (nim.available(n2) == 0) {
                n2 = (n2 + 1) % n3;
            }
            return new Nim.Move(n2, 1);
        }
        if (this.reverseGame && n5 == 1) {
            n = nim.available(n7) + n4 % 2 - 1;
            return new Nim.Move(n7, n);
        }
        return this.goodMove(nim, n3, n6);
    }

    private Nim.Move goodMove(Nim nim, int n, int n2) {
        int n3;
        int n4 = CleverStrategy.binLength(n2);
        int[][] nArray = new int[n + 2][n4];
        int n5 = n;
        int n6 = n + 1;
        CleverStrategy.clear(nArray[n5]);
        for (n3 = 0; n3 < n; ++n3) {
            CleverStrategy.binCode(nim.available(n3), nArray[n3], nArray[n5]);
        }
        int n7 = CleverStrategy.leftmostOdd(nArray[n5]);
        if (n7 == -1) {
            n3 = Math.abs(this.random.nextInt()) % n;
            while (nim.available(n3) == 0) {
                n3 = (n3 + 1) % n;
            }
            return new Nim.Move(n3, 1);
        }
        n3 = Math.abs(this.random.nextInt()) % n;
        while (nArray[n3][n7] == 0) {
            n3 = (n3 + 1) % n;
        }
        CleverStrategy.targetBinRep(nArray[n3], nArray[n5], nArray[n6]);
        int n8 = CleverStrategy.value(nArray[n3]) - CleverStrategy.value(nArray[n6]);
        return new Nim.Move(n3, n8);
    }

    private static int binLength(int n) {
        int n2 = 0;
        do {
            ++n2;
        } while ((n /= 2) > 0);
        return n2;
    }

    private static void clear(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
    }

    private static int value(int[] nArray) {
        int n = 0;
        for (int i = nArray.length - 1; i >= 0; --i) {
            n = 2 * n;
            if (nArray[i] != 1) continue;
            ++n;
        }
        return n;
    }

    private static void binCode(int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n % 2;
            if (nArray[i] == 1) {
                nArray2[i] = nArray2[i] + 1;
            }
            n /= 2;
        }
    }

    private static int leftmostOdd(int[] nArray) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] % 2 == 0) continue;
            return i;
        }
        return -1;
    }

    private static void targetBinRep(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray2[i] % 2 == 0 ? nArray[i] : (nArray[i] + 1) % 2;
        }
    }
}

