#define trigPin 5    // Trigger
#define echoPin 4    // Echo

void setup() {
  Serial.begin (9600);
  pinMode(trigPin, OUTPUT);
  pinMode(echoPin, INPUT);
}

void loop() {
  // Il segnale di trigger deve restare HIGH per almeno 10 ms.
  // Quindi si emette prima un breve segnale LOW, per assicurare
  // il rilevamento del trigger HIGH:
  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);
  // duration è la durata in ms dall'emissione del ping
  // alla ricezione dell'echo per riflessione da un oggetto.
  long duration = pulseIn(echoPin, HIGH);
  // Conversione del tempo in distanza
  long cm = (duration/2) / 29.1;     // divisione per 29.1 o moltiplicazione per 0.0343
  Serial.print(cm);
  Serial.print("cm");
  Serial.println();
  delay(250);
}
