#define ML_Ctrl 13 // associa il pin di controllo di direzione del motore di sinistra
#define ML_PWM 11  // associa il pin di velocità del motore di sinistra 
#define MR_Ctrl 12 // associa il pin di controllo di direzione del motore di destra
#define MR_PWM 3   // associa il pin di velocità del motore di destra

void setup() {
  pinMode(ML_Ctrl, OUTPUT); // imposta il pin della dir. del motore sinistro come output
  pinMode(ML_PWM, OUTPUT);  // imposta il pin della vel. del motore sinistro come output
  pinMode(MR_Ctrl, OUTPUT); // imposta il pin della dir. del motore destro come output
  pinMode(MR_PWM, OUTPUT);  // imposta il pin della vel. del motore destro come output
}

void loop() { 
  // va avanti
  digitalWrite(ML_Ctrl,LOW); // direzione di rotazione del motore sinistro: avanti (LOW)
  analogWrite(ML_PWM,200);   // velocità del motore sinistro: 200
  digitalWrite(MR_Ctrl,LOW); // direzione di rotazione del motore destro: avanti (LOW)
  analogWrite(MR_PWM,200);   // velocità del motore destro: 200
  delay(2000);               // attende 2s
  // va indietro
  digitalWrite(ML_Ctrl,HIGH); // direzione di rotazione del motore sinistro: indietro (HIGH)
  analogWrite(ML_PWM,200);    // velocità del motore sinistro: 200  
  digitalWrite(MR_Ctrl,HIGH); // direzione di rotazione del motore destro: indietro (HIGH)
  analogWrite(MR_PWM,200);    // velocità del motore destro: 200
  delay(2000);                // attende 2s
  // gira a sinistra
  digitalWrite(ML_Ctrl,HIGH); // direzione di rotazione del motore sinistro: indietro (HIGH)
  analogWrite(ML_PWM,200);    // velocità del motore sinistro: 200
  digitalWrite(MR_Ctrl,LOW);  // direzione di rotazione del motore destro: avanti (LOW)
  analogWrite(MR_PWM,200);    // velocità del motore destro: 200
  delay(2000);                // attende 2s
  // gira a destra
  digitalWrite(ML_Ctrl,LOW);  // direzione di rotazione del motore sinistro: avanti (LOW)
  analogWrite(ML_PWM,200);    // velocità del motore sinistro: 200
  digitalWrite(MR_Ctrl,HIGH); // direzione di rotazione del motore destro: indietro (HIGH)
  analogWrite(MR_PWM,200);    // velocità del motore destro: 200
  delay(2000);                // attende 2s
  // stop (azzera la velocità dei motori)
  analogWrite(ML_PWM,0);      // velocità del motore sinistro: 0
  analogWrite(MR_PWM,0);      // velocità del motore destro: 0
  delay(2000);                // attende 2s
}
