import processing.serial.*;
import cc.arduino.*;

static final int WINDOW_COLS=640;
static final int WINDOW_ROWS=480;
static final int RECT_WIDTH=500;
static final int RECT_HEIGHT=100;
static final int FONT_SIZE=16;

PGraphics pg;
PFont f;

int potpin=0; // PIN collegato al potenziometro
Arduino arduino; // oggetto di tipo Arduino: serve a dialogare con la board
boolean arduinoCheck=false; // booleano: true -> Arduino collegato, false -> Arduino assente

void setup() {
  surface.setSize(WINDOW_COLS,WINDOW_ROWS);
  pg = createGraphics(WINDOW_COLS, WINDOW_ROWS);
  f = createFont("Arial",FONT_SIZE,true);

  try {
    println((Object[])Arduino.list());
    arduino = new Arduino(this, Arduino.list()[4], 57600);
    arduino.pinMode(potpin,Arduino.INPUT);
    arduinoCheck=true;
  }
  catch(Exception e) {
    println("Error: "+e.toString());
    arduinoCheck=false;
  }
  
}

void draw() {
  background(#FFFFFF);
  pg.beginDraw();
  pg.clear();
  pg.smooth();
  pg.fill(0);
  pg.textFont(f);
  pg.textAlign(CENTER);
  pg.text("0%",WINDOW_COLS/2-RECT_WIDTH/2,WINDOW_ROWS/2+RECT_HEIGHT/2+FONT_SIZE); 
  pg.text("25%",WINDOW_COLS/2-RECT_WIDTH/4,WINDOW_ROWS/2+RECT_HEIGHT/2+FONT_SIZE); 
  pg.text("50%",WINDOW_COLS/2,WINDOW_ROWS/2+RECT_HEIGHT/2+FONT_SIZE);
  pg.text("75%",WINDOW_COLS/2+RECT_WIDTH/4,WINDOW_ROWS/2+RECT_HEIGHT/2+FONT_SIZE); 
  pg.text("100%",WINDOW_COLS/2+RECT_WIDTH/2,WINDOW_ROWS/2+RECT_HEIGHT/2+FONT_SIZE);
  pg.rectMode(CENTER);
  pg.fill(255,255,255);
  pg.rect(WINDOW_COLS/2,WINDOW_ROWS/2,RECT_WIDTH,RECT_HEIGHT);
  pg.line(WINDOW_COLS/2-RECT_WIDTH/4,WINDOW_ROWS/2+RECT_HEIGHT/2,WINDOW_COLS/2-RECT_WIDTH/4,WINDOW_ROWS/2-RECT_HEIGHT/2);
  pg.line(WINDOW_COLS/2,WINDOW_ROWS/2+RECT_HEIGHT/2,WINDOW_COLS/2,WINDOW_ROWS/2-RECT_HEIGHT/2);
  pg.line(WINDOW_COLS/2+RECT_WIDTH/4,WINDOW_ROWS/2+RECT_HEIGHT/2,WINDOW_COLS/2+RECT_WIDTH/4,WINDOW_ROWS/2-RECT_HEIGHT/2);

  if(arduinoCheck) {
    int val=arduino.analogRead(potpin);
    int mappedVal=(int)map(val,0,1023,0,RECT_WIDTH);
    println("*****"+mappedVal+"*****");
    
    if(mappedVal<=RECT_WIDTH/4)
      pg.fill(225,255,204);
    if(mappedVal>RECT_WIDTH/4 && mappedVal<=RECT_WIDTH/2)
      pg.fill(255,255,0);
    if(mappedVal>=RECT_WIDTH/2 && mappedVal<=RECT_WIDTH/4*3)
      pg.fill(255,153,102);
    if(mappedVal>RECT_WIDTH/4*3)
      pg.fill(255,0,0);
    pg.rect(WINDOW_COLS/2-RECT_WIDTH/2+mappedVal/2,WINDOW_ROWS/2,mappedVal,RECT_HEIGHT);
  }

  pg.endDraw();
  
  image(pg,0,0);
}
