import processing.serial.*;
import cc.arduino.*;
import java.util.*;

static final int WINDOW_COLS=640;
static final int WINDOW_ROWS=480;
static final int FONT_SIZE=16;

PGraphics pg;
PFont f;

String[] devices;
Arduino[] arduino=null; // Array di oggetti di tipo Arduino: serve a dialogare con la board
int ledPin=13;

String label1="Porte COM rilevate: ";
List<Button> pulsanti=new ArrayList<Button>();

String[] serialList() {
  String[] l=null;
  try {
    l=Arduino.list();
  }
  catch(Exception e) {
    println("Error: "+e.toString());
    l=new String[0];
  }
  
  return l;
}

void setup() {
  surface.setSize(WINDOW_COLS,WINDOW_ROWS);
  pg = createGraphics(WINDOW_COLS, WINDOW_ROWS);
  f = createFont("Arial",FONT_SIZE,true);
  
  devices=serialList();
  println(devices);
  arduino=new Arduino[devices.length];
  for(int i=0; i<arduino.length; i++)
    arduino[i]=null;
}

void draw() {
  background(#FFFFFF);
  pg.beginDraw();
  pg.clear();
  pg.smooth();
  pg.fill(0);
  pg.textFont(f);
  pg.textAlign(LEFT);
  int margineSx=WINDOW_COLS/8;
  pg.text(label1,margineSx,WINDOW_ROWS/4);
  margineSx+=pg.textWidth(label1);
  pulsanti.clear();
  for(int i=0; i<devices.length; i++) {
    pg.textAlign(LEFT);
    pg.text(devices[i],margineSx,WINDOW_ROWS/4+i*(FONT_SIZE+50));
    pulsanti.add(new Button(devices[i],margineSx+pg.textWidth(devices[i])+110,WINDOW_ROWS/4+i*(FONT_SIZE+50),100,50));
    pulsanti.get(i).Draw();
  }
  pg.endDraw();
  
  image(pg,0,0);
}

void mousePressed() {
  
  for(int i=0; i<devices.length; i++) {
    if(pulsanti.get(i).MouseIsOver()) {
      println("Pulsante n."+(i+1));
      try {
        if(arduino[i]==null)
          arduino[i] = new Arduino(this, devices[i], 57600);
        arduino[i].pinMode(13, Arduino.OUTPUT);
        arduino[i].digitalWrite(13,Arduino.HIGH);
        delay(5000);
        arduino[i].digitalWrite(13,Arduino.LOW);
      }
      catch(Exception e) {
        println("Errore: "+e.toString());
      }
      break;
    }
  }

}

class Button {
  String label;
  float x;    // center x position
  float y;    // center y position
  float w;    // width of button
  float h;    // height of button
  
  Button(String labelB, float xpos, float ypos, float widthB, float heightB) {
    label = labelB;
    x = xpos;
    y = ypos;
    w = widthB;
    h = heightB;
  }
  
  void Draw() {
    pg.rectMode(CENTER);
    pg.fill(218);
    pg.stroke(141);
    pg.rect(x, y, w, h, 10);
    pg.textAlign(CENTER, CENTER);
    pg.fill(0);
    pg.text(label, x, y);
  }
  
  boolean MouseIsOver() {
    if (mouseX > (x - w/2) && mouseX < (x + w/2) && mouseY > (y - h/2) && mouseY < (y + h/2)) {
      return true;
    }
    return false;
  }
}
