import java.awt.event.KeyEvent;

static final boolean DEBUG=false;
static final float TOLERANCE_PCT=0.99;
static final int WINDOW_COLS=640;
static final int WINDOW_ROWS=480;
static final int TOTAL_ROWS=20;
static final int TOTAL_COLS=8;
static final int BLOCK_ROWS=10;
static final int BLOCK_COLS=8;
static final float STEP_X=7.0;
static final int POINTS_PER_BLOCK=100;
static final float BALL_SPEED=2.5;

PGraphics pg;

int blocksNum;

float blockHeight=WINDOW_ROWS/TOTAL_ROWS;
float blockWidth=WINDOW_COLS/TOTAL_COLS;
boolean[][] blocks=new boolean[TOTAL_ROWS][TOTAL_COLS];
color[][] blockColors=new color[TOTAL_ROWS][TOTAL_COLS];

float paddleWidth=blockWidth*0.7;
float paddleHeight=blockHeight*0.2;
float paddleX,paddleY;

float ballRadius=blockHeight<=blockWidth ? blockHeight*0.5 : blockWidth*0.5;
float ballX,ballY;
float ballStepX,ballStepY;
boolean ballAnimation=false;

int life, points;
int matchStatus; /* 0=terminata, 1=in corso, 2=pausa */

void drawBlocks() {
  for(int i=0; i<TOTAL_ROWS; i++) {
    for(int j=0; j<TOTAL_COLS; j++) {
      if(blocks[i][j]) {
        fill(blockColors[i][j]);
        rect(j*blockWidth,(TOTAL_ROWS-i-1)*blockHeight,blockWidth,blockHeight);
      }
    }
  }
  
}

void drawPaddle() {
  pg.beginDraw();
  fill(#000000);
  rect(paddleX,paddleY,paddleWidth,paddleHeight);
  pg.endDraw();
}

void resetPaddle() {
  paddleX=WINDOW_COLS/2-paddleWidth/2;
  paddleY=WINDOW_ROWS-paddleHeight;
}

void resetBall() {
  ballX=WINDOW_COLS/2;
  ballY=WINDOW_ROWS-paddleHeight-ballRadius;
}

void drawBall() {
  int rightCol;
  int leftCol;
  int rowUp;
  int rowDown;

  if(DEBUG) {
    rightCol=ceil((ballX+ballRadius)/blockWidth)-1;
    leftCol=ceil((ballX-ballRadius)/blockWidth)-1;
    rowUp=TOTAL_ROWS-ceil((ballY-ballRadius)/blockHeight);
    rowDown=TOTAL_ROWS-ceil((ballY+ballRadius)/blockHeight);
  }
  
  pg.beginDraw();
  fill(#00FF00);
  ellipse(ballX,ballY,2*ballRadius,2*ballRadius);
  if(DEBUG) {
    fill(#00FF00,0.0);
    rect(leftCol*blockWidth,(TOTAL_ROWS-rowUp-1)*blockHeight,blockWidth,blockHeight);
    rect(rightCol*blockWidth,(TOTAL_ROWS-rowUp-1)*blockHeight,blockWidth,blockHeight);
    rect(leftCol*blockWidth,(TOTAL_ROWS-rowDown-1)*blockHeight,blockWidth,blockHeight);
    rect(rightCol*blockWidth,(TOTAL_ROWS-rowDown-1)*blockHeight,blockWidth,blockHeight);
  }
  pg.endDraw();
}

void initialDir() {
  float r=floor(random(0,1)*2);
  ballStepX=(r<1 ? -BALL_SPEED : BALL_SPEED)*random(0,1);
  ballStepY=-BALL_SPEED;
}

void resetBlocks() {
  for(int i=0; i<TOTAL_ROWS; i++) {
    for(int j=0; j<TOTAL_COLS; j++) {
      if(j>=(TOTAL_COLS-BLOCK_COLS)/2 && j<(TOTAL_COLS-BLOCK_COLS)/2+BLOCK_COLS && i>=TOTAL_ROWS-BLOCK_ROWS) {
        blocks[i][j]=true;
        color c=color((int)random(0,255),(int)random(0,255),(int)random(0,255));
        blockColors[i][j]=c;
      }
      else {
        blocks[i][j]=false;
        blockColors[i][j]=#FFFFFF;
      }
    }
  }
}

void setup() {
  blocksNum=BLOCK_ROWS*BLOCK_COLS;
  life=3;
  points=0;
  matchStatus=0;
  surface.setSize(WINDOW_COLS,WINDOW_ROWS);
  pg = createGraphics(WINDOW_COLS, WINDOW_ROWS);
  
  resetBlocks();  
  resetPaddle();
  resetBall();
  initialDir();
}

void moveBall() {
  boolean collision=ballX>=paddleX && ballX<=paddleX+paddleWidth && ballY>=paddleY-ballRadius;
  int rightCol=ceil((ballX+ballRadius)/blockWidth)-1;
  int leftCol=ceil((ballX-ballRadius)/blockWidth)-1;
  int rowUp=TOTAL_ROWS-ceil((ballY-ballRadius)/blockHeight);
  int rowDown=TOTAL_ROWS-ceil((ballY+ballRadius)/blockHeight);
  
  if(DEBUG) {
    print("indice della colonna a sinistra: "+leftCol+"\n"); 
    print("indice della colonna a destra: "+rightCol+"\n"); 
    print("indice della riga in alto: "+rowUp+"\n"); 
    print("indice della riga in basso: "+rowDown+"\n"); 
  }

  boolean blockHit=false;
    
  if(rowDown>=TOTAL_ROWS-BLOCK_ROWS && rowDown<TOTAL_ROWS && leftCol>=0 && leftCol<TOTAL_COLS) {
    if(blocks[rowDown][leftCol]) {
      if(DEBUG)
        print("Blocco colpito!***********************************************************\n");
      blocks[rowDown][leftCol]=false;
      blocksNum--;
      points+=POINTS_PER_BLOCK;
      if(ballX-ballRadius>=(leftCol+1)*blockWidth*TOLERANCE_PCT) {
        ballStepX*=-1;
      }
      else {
        ballStepY*=-1;
      }
      blockHit=true;
    }
  };

  if(!blockHit && rowDown>=TOTAL_ROWS-BLOCK_ROWS && rowDown<TOTAL_ROWS && rightCol>=0 && rightCol<TOTAL_COLS) {
    if(blocks[rowDown][rightCol]) {
      if(DEBUG)
        print("Blocco colpito!***********************************************************\n");
      blocks[rowDown][rightCol]=false;
      blocksNum--;
      points+=POINTS_PER_BLOCK;
      if((ballX+ballRadius)*TOLERANCE_PCT<=(rightCol)*blockWidth) {
        ballStepX*=-1;
      }
      else {
        ballStepY*=-1;
      }
      blockHit=true;
    }
  }

  if(!blockHit && rowUp>=TOTAL_ROWS-BLOCK_ROWS && rowUp<TOTAL_ROWS && leftCol>=0 && leftCol<TOTAL_COLS) {
    if(blocks[rowUp][leftCol]) {
      if(DEBUG)
        print("Blocco colpito!***********************************************************\n");
      blocks[rowUp][leftCol]=false;
      blocksNum--;
      points+=POINTS_PER_BLOCK;
      if(ballX-ballRadius>=(leftCol+1)*blockWidth*TOLERANCE_PCT) {
        ballStepX*=-1;
      }
      else {
        ballStepY*=-1;
      }
      blockHit=true;
    }
  }

  if(!blockHit && rowUp>=TOTAL_ROWS-BLOCK_ROWS && rowUp<TOTAL_ROWS && rightCol>=0 && rightCol<TOTAL_COLS) {
    if(blocks[rowUp][rightCol]) {
      if(DEBUG)
        print("Blocco colpito!***********************************************************\n");
      blocks[rowUp][rightCol]=false;
      blocksNum--;
      points+=POINTS_PER_BLOCK;
      if((ballX+ballRadius)*TOLERANCE_PCT<=(rightCol)*blockWidth) {
        ballStepX*=-1;
      }
      else {
        ballStepY*=-1;
      }
      blockHit=true;
    }
  }

  if(collision) {
    ballStepY=-BALL_SPEED;
    if(ballX<paddleX+paddleWidth/3)
      ballStepX=-random(0,1)*BALL_SPEED;
    if(ballX>paddleX+2*paddleWidth/3)
      ballStepX=random(0,1)*BALL_SPEED;
    if(DEBUG)
      print("rimbalzo sulla paletta\n");
  } else {
    if(ballX-ballRadius<=0 || ballX+ballRadius>=WINDOW_COLS) {
      ballStepX*=-1;
      if(DEBUG) {
        if(ballX+ballRadius>=WINDOW_COLS) print("rimbalzo su muro a destra\n"); else print("rimbalzo su muro a sinistra\n");
      }
    }

    if(ballY-ballRadius<=0 || ballY+ballRadius>=WINDOW_ROWS) {
      ballStepY*=-1;
      if(DEBUG) {
        if(ballY+ballRadius>=WINDOW_ROWS) print("rimbalzo sul fondo\n"); else print("rimbalzo su muro in alto\n");
      }
      if(ballY+ballRadius>=WINDOW_ROWS) {
        life--;
        print("Vite rimanenti: "+life+"\n");
      }
        
    }

  }
    
  if(life==0 || blocksNum==0) {
    print("game over! score: "+points+"\n");
    ballAnimation=false;
    matchStatus=0;
  }

  ballX+=ballStepX+((int)(random(0,1)*5)==4 ? 1 : 0);
  ballY+=ballStepY+((int)(random(0,1)*5)==4 ? 1 : 0);
}

void draw() {
  if(ballAnimation)
    moveBall();
  
  background(#FFFFFF);
  pg.beginDraw();
  pg.clear();
  drawBlocks();
  drawPaddle();
  drawBall();
  pg.endDraw();
  
  image(pg,0,0);
}

void keyPressed() {
   if (key == CODED) {
    if(keyCode==LEFT && matchStatus==1 && paddleX>0) {
      paddleX-=STEP_X;
    }
    if(keyCode==RIGHT && matchStatus==1 && paddleX+paddleWidth<WINDOW_COLS) {
      paddleX+=STEP_X;
    }
    if(keyCode==KeyEvent.VK_F1) {
      resetBlocks();
      blocksNum=BLOCK_ROWS*BLOCK_COLS;
      resetBall();
      resetPaddle();
      life=3;
      points=0;
      matchStatus=1;
      ballAnimation=true;
    }
    if(keyCode==KeyEvent.VK_F2 && matchStatus!=0) {
      if(ballAnimation) {
        ballAnimation=false;
        matchStatus=2;
      }
      else {
        ballAnimation=true;
        matchStatus=1;
      }
    }
   }
}
