import processing.serial.*;
import cc.arduino.*;
import java.util.*;

static final int WINDOW_COLS=640;
static final int WINDOW_ROWS=480;
static final int FONT_SIZE=16;
static final int LED_PIN=13;
static final String COM_PORT="COM8";
static final int RADIUS=200;

PGraphics pg;
PFont f;

Arduino arduino=null;

String label1="Stato del LED: ";
int ellipseColor=#FFFFFF;

void setup() {
  surface.setSize(WINDOW_COLS,WINDOW_ROWS);
  pg = createGraphics(WINDOW_COLS, WINDOW_ROWS);
  f = createFont("Arial",FONT_SIZE,true);
  try {
    arduino=new Arduino(this, COM_PORT, 57600);
  }
  catch(Exception e) {
    println("Errore: "+e.toString());
  }
}

void draw() {
  background(#FFFFFF);
  pg.beginDraw();
  pg.clear();
  pg.smooth();
  pg.fill(0);
  pg.textFont(f);
  pg.textAlign(LEFT);
  int margineSx=WINDOW_COLS/2;
  pg.text(label1,margineSx-pg.textWidth(label1)/2,WINDOW_ROWS/4);
  margineSx+=pg.textWidth(label1);
  pg.fill(ellipseColor);
  pg.ellipse(WINDOW_COLS/2,WINDOW_ROWS/2,RADIUS,RADIUS);
  pg.endDraw();
  
  image(pg,0,0);
}

void mousePressed() {
  if(arduino!=null) {
    arduino.pinMode(LED_PIN, Arduino.OUTPUT);
    arduino.digitalWrite(LED_PIN,Arduino.HIGH);
    ellipseColor=#FF0000;
    println("LED "+LED_PIN+" acceso");
  }
}

void mouseReleased() {
  if(arduino!=null) {
    arduino.pinMode(LED_PIN, Arduino.OUTPUT);
    arduino.digitalWrite(LED_PIN,Arduino.LOW);
    ellipseColor=#FFFFFF;    
    println("LED "+LED_PIN+" spento");
  }
}
