import processing.serial.*;
import cc.arduino.*;

static final int WINDOW_COLS=640;
static final int WINDOW_ROWS=480;
static final int SPINDLE_DIAMETER=10;
static final int PROPELLER_BODY_LENGTH=200; 
static final int PROPELLER_TIP_LENGTH=30;
static final int OFF_THRESHOLD=59;
static final int MAX_THRESHOLD=161;
static final int MIDDLE_THRESHOLD=OFF_THRESHOLD+1+(MAX_THRESHOLD-OFF_THRESHOLD-1)/2;
static final float MOTOR_EFFICIENCY=0.85;  // Efficienza del motore: 85%
static final float RPM=920*12.6*MOTOR_EFFICIENCY;  // Rotazioni per minuto del motore a 12.6 V (batteria pienamente carica)
static final float RPS=RPM/60.0;  // Rotazioni per secondo del motore a 12.6 V (batteria pienamente carica)

PGraphics pg;
PFont f;

int potPin = 0; // PIN collegato al potenziometro
int ledPin = 9; // PIN collegato al LED
int servoPin = 10; // PIN collegato all'ESC
Arduino arduino; // oggetto di tipo Arduino: serve a dialogare con la board
boolean arduinoCheck=false; // booleano: true -> Arduino collegato, false -> Arduino assente

float rotAngle=0.0;

void setup() {
  surface.setSize(WINDOW_COLS,WINDOW_ROWS);
  pg = createGraphics(WINDOW_COLS, WINDOW_ROWS);
  f = createFont("Arial",16,true);

  try {
    println((Object[])Arduino.list());
    arduino = new Arduino(this, Arduino.list()[0], 57600);
    arduino.pinMode(ledPin, Arduino.OUTPUT);
    arduino.digitalWrite(ledPin, Arduino.LOW);
    arduino.pinMode(potPin, Arduino.INPUT);
    arduino.pinMode(servoPin,Arduino.SERVO);
    arduinoCheck=true;
  }
  catch(Exception e) {
    println("Error: "+e.toString());
    arduinoCheck=false;
  }

  delay(1000);
}

void draw() {
  int val=0;
  
  if(arduinoCheck) {
    val=arduino.analogRead(potPin);
    val = (int)map(val, 0, 1023, OFF_THRESHOLD, MAX_THRESHOLD);
    println(val);
    arduino.servoWrite(servoPin,val);
    if(val>=MIDDLE_THRESHOLD)
      arduino.digitalWrite(ledPin,Arduino.HIGH);
    else
      arduino.digitalWrite(ledPin,Arduino.LOW);
  }
  
  background(#FFFFFF);
  pg.beginDraw();
  pg.clear();
  pg.smooth();
  pg.fill(0);
  pg.textFont(f);
  pg.textAlign(RIGHT);
  pg.translate(WINDOW_COLS/2, WINDOW_ROWS/2);
  pg.rotate(rotAngle);
  pg.ellipse(0, 0, SPINDLE_DIAMETER, SPINDLE_DIAMETER);
  pg.triangle(SPINDLE_DIAMETER/2, 0, SPINDLE_DIAMETER/2+PROPELLER_BODY_LENGTH, PROPELLER_TIP_LENGTH, SPINDLE_DIAMETER/2+PROPELLER_BODY_LENGTH, -PROPELLER_TIP_LENGTH);
  pg.triangle(SPINDLE_DIAMETER/2+PROPELLER_BODY_LENGTH, PROPELLER_TIP_LENGTH, SPINDLE_DIAMETER/2+PROPELLER_BODY_LENGTH, -PROPELLER_TIP_LENGTH, SPINDLE_DIAMETER/2+PROPELLER_BODY_LENGTH+PROPELLER_TIP_LENGTH, 0);
  pg.triangle(-SPINDLE_DIAMETER/2, 0, -SPINDLE_DIAMETER/2-PROPELLER_BODY_LENGTH, PROPELLER_TIP_LENGTH, -SPINDLE_DIAMETER/2-PROPELLER_BODY_LENGTH, -PROPELLER_TIP_LENGTH);
  pg.triangle(-SPINDLE_DIAMETER/2-PROPELLER_BODY_LENGTH, PROPELLER_TIP_LENGTH, -SPINDLE_DIAMETER/2-PROPELLER_BODY_LENGTH, -PROPELLER_TIP_LENGTH, -SPINDLE_DIAMETER/2-PROPELLER_BODY_LENGTH-PROPELLER_TIP_LENGTH, 0);
  pg.endDraw();
  
  image(pg,0,0);
  if(val>OFF_THRESHOLD)
    rotAngle+=2*PI*RPS*(val-OFF_THRESHOLD)/(MAX_THRESHOLD-OFF_THRESHOLD);
}
